package com.blt.other.module.cost.utils;

import com.google.gson.Gson;
import com.qiniu.common.QiniuException;
import com.qiniu.http.Response;
import com.qiniu.storage.Configuration;
import com.qiniu.storage.Region;
import com.qiniu.storage.UploadManager;
import com.qiniu.storage.model.DefaultPutRet;
import com.qiniu.util.Auth;
import org.springframework.web.multipart.MultipartFile;

import java.io.IOException;
import java.io.InputStream;

public class QNUtils {
    /**
     * Key
     */
    private static final String ACCESS_KEY = "QSvtvN4Ons1CiNzaMGqx8XmDaiM1L0ZqSwJ2YoTn";

    /**
     * 秘钥
     */
    private static final String SECRET_KEY = "yagRd-cBOVhkRGGT-o_reMqNVjI8_k7YwoTXkhrm";

    /**
     * 存储桶
     */
    private static final String BUCKET = "uibot";


    private static final String BASE_URL = "qv3ist3f9.hn-bkt.clouddn.com";

    /**
     * 上传管理
     */
    private static UploadManager uploadManager;

    private QNUtils() {
        //构造一个带指定 Region 对象的配置类
        Configuration config = new Configuration(Region.region2());
        uploadManager = new UploadManager(config);
    }

    private static UploadManager getInstance() {
        if (uploadManager == null) {
            new QNUtils();
        }
        return uploadManager;
    }


    /**
     * 生成上传凭证Token
     *
     * @return
     */
    public static String getToken() {
        Auth auth = Auth.create(ACCESS_KEY, SECRET_KEY);
        String upToken = auth.uploadToken(BUCKET);
        System.out.println(upToken);
        return upToken;
    }

    public static String upLoad(MultipartFile file) {

        // 默认不指定key的情况下，以文件内容的hash值作为文件名
        String key = file.getOriginalFilename();
        String url="";
        try {
            InputStream inputStream = file.getInputStream();
//            byte[] byteData = IOUtils.toByteArray(inputStream);//把流转字节数组
            Response response = getInstance().put(inputStream, key, getToken(), null, null);
//            Response response = getInstance().put(byteData, key, getToken());
            //解析上传成功的结果
            try {
                DefaultPutRet putRet = new Gson().fromJson(response.bodyString(), DefaultPutRet.class);
                System.out.println(putRet.key);
                System.out.println(putRet.hash);
                url = BASE_URL+"/"+putRet.key;
            } catch (QiniuException e) {
                Response r = e.response;
                System.err.println(r.toString());
                try {
                    System.err.println(r.bodyString());
                } catch (QiniuException ex2) {
                    //ignore
                }
            }
        } catch (IOException e) {
            e.printStackTrace();
        }
        return url;
    }





}
