package com.blt.other.module.cost.service.impl.costplan;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.blt.other.common.exception.BizRuntimeException;
import com.blt.other.common.util.CurUtils;
import com.blt.other.database.model.CostPlanDomain;
import com.blt.other.database.model.CostPlanTempDomain;
import com.blt.other.module.cost.model.CostDomain;
import com.blt.other.module.cost.service.CostPlanService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.time.LocalDateTime;


/**
 * <p>
 * 借还单服务
 * </p>
 *
 * @author robbendev
 * @since 2020/10/16 1:25 下午
 */
@Slf4j
@Service
@Transactional(rollbackFor = Exception.class)
public class CostPlanNewLend2ServiceImpl extends AbstractCostPlanService implements CostPlanService {

    @Override
    public void save(CostPlanDomain planDomain) {
        this.doSaveFinanceRecord(planDomain);
        this.completedCostPlan(planDomain);
        planDomain.setCostPlanStatus(0);

        this.check(planDomain);


        costPlanDao.insert(planDomain);
    }

    @Override
    public void update(CostPlanDomain planDomain) {
        this.doSaveFinanceRecord(planDomain);
        this.completedCostPlan(planDomain);

        costPlanDao.update(planDomain, new LambdaQueryWrapper<CostPlanDomain>()
                .eq(CostPlanDomain::getCostPlanNo, planDomain.getCostPlanNo()));

    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public Integer affirm(String costPlanNo) {
        CostPlanDomain costPlanDomain = costPlanDao.selectByNo(costPlanNo);
        if (costPlanDomain.getCostPlanStatus() != 0) {
            throw new BizRuntimeException("只能更新待确认的计划单");
        }
        affirmCounteract(costPlanNo);
        affirmLendBalance(costPlanNo);
        return 1;
    }

    /**
     * 确认冲销金额
     * @param costPlanNo
     */
    private void affirmCounteract(String costPlanNo) {

        CostPlanDomain costPlanDomain = costPlanDao.selectByNo(costPlanNo);

        //已确认
        costPlanDomain.setCostPlanStatus(1);
        costPlanDao.updateById(costPlanDomain);

        //关联的借支单
        CostDomain supCost = costService.getCostByCostNo(costPlanDomain.getSupCostNo());
        //借支还需要还的金额 （借支单币种） = 借支单金额 -  借支单已还金额
        BigDecimal subtract = supCost.getAmount().subtract(supCost.getRepaymentAppliedAmount());
        if (subtract.compareTo(BigDecimal.ZERO) <= 0) {
            throw new BizRuntimeException("待归还金额 = 0 无需再冲销");
        }

        //借还单冲销金额 (借支单币种)
        BigDecimal counteract = costPlanDomain.getCounteract();
        if (counteract.compareTo(BigDecimal.ZERO) <= 0) {
            return;
        }

        // 2.1、冲销刚好抵消差额 / 冲销小于差额  ===== 生成一张无需推送财务系统的借还单
        if (counteract.compareTo(subtract) <= 0) {
            costPlanDomain.setLendBalance(BigDecimal.ZERO);
            CostDomain costDomain = planToCost(costPlanDomain.getCostPlanNo());
            costDomain.setCostNo(getCostNo());
            costDomain.setCostStatus(0);
            costDomain.setAmount(costDomain.getCounteract());
            costDomain.setLendBalance(BigDecimal.ZERO);
            costDomain.setPayPlanAmount(costDomain.getPayCounteract());
            costDomain.setPayLendBalance(BigDecimal.ZERO);
            BigDecimal toRmbRate = CurUtils.getCur(costDomain.getDic(), "CNY");
            costDomain.setToRmbRate(toRmbRate);
            costDomain.setAmountRmb(costDomain.getAmount().multiply(toRmbRate).setScale(2, BigDecimal.ROUND_HALF_UP));

            costDao.insert(costDomain);

            //更新借支单申请归还金额
            supCost.setRepaymentAppliedAmount(supCost.getRepaymentAppliedAmount().add(counteract));
            supCost.setLastModifyDate(LocalDateTime.now());
            costDao.updateById(supCost);

            log.info("冲销刚好抵消差额 / 冲销小于差额  ===== 生成一张无需付款的借还单：" + costDomain);
            // 记录日志
            costLogService.save(costDomain.getCostNo(), costDomain.getCreateUserid(), "由费用计划：" + costDomain.getCostPlanNo() + " 生成冲销单");
        }
        // 冲销大于差额  ===== 生成一张无需收款的借还单 + 一张付款单（出纳回调接口和财务审核接口改为借还出纳回调接口，费用单号以 “S” 打头）
        else {
            log.info("冲销大于差额  ===== 准备生成一张无需收款的借还单 + 一张付款单（出纳回调接口和财务审核接口改为借还出纳回调接口，费用单号以 “S” 打头）");
            costPlanDomain.setLendBalance(BigDecimal.ZERO);
            CostDomain costDomain = planToCost(costPlanDomain.getCostPlanNo());
            costDomain.setCostNo(getCostNo());
            costDomain.setCostStatus(0);
            costDomain.setAmount(subtract);
            costDomain.setCounteract(subtract);
            costDomain.setPayPlanAmount(subtract.divide(costPlanDomain.getPayCur(), 4));
            costDomain.setPayCounteract(subtract.divide(costPlanDomain.getPayCur(), 4));
            BigDecimal toRmbRate = CurUtils.getCur(costDomain.getDic(), "CNY");
            costDomain.setToRmbRate(toRmbRate);
            costDomain.setAmountRmb(costDomain.getAmount().multiply(toRmbRate).setScale(2, BigDecimal.ROUND_HALF_UP));
            costDao.insert(costDomain);


            //更新借支单申请归还金额
            supCost.setRepaymentAppliedAmount(supCost.getRepaymentAppliedAmount().add(costDomain.getCounteract()));
            supCost.setLastModifyDate(LocalDateTime.now());
            costDao.updateById(supCost);

            log.info("生成一张无需收款的借还单：" + costDomain);
            // 记录日志
            costLogService.save(costDomain.getCostNo(), costDomain.getCreateUserid(), "由费用计划：" + costDomain.getCostPlanNo() + " 生成冲销单");

            /*
             *  改为生成一张待提交的付款计划  且必须选择付款子项后才能确认（前端判断costTemps，后端判断是否有子项目）
             *  差额计划单生成付款费用单时，费用单号保留 S 打头
             *  差额计划单的总额、创建一个空的子项目，但是不选类型
             *  前端 costForm = 1  isLend = 2 时，不可以删除自动生成的空的子项目，只能修改（后端删除子项目的环节同样需要判断）
             */
            CostPlanDomain payPlan = new CostPlanDomain();
            BeanUtils.copyProperties(costPlanDomain, payPlan);

            //付款金额 (关联借支单币种)
            BigDecimal compensate = costPlanDomain.getCounteract().subtract(subtract);
            payPlan.setCostPlanNo("S" + createNo());
            payPlan.setCostPlanStatus(0);
            //付款单
            payPlan.setCostForm(1);
            //借还
            payPlan.setIsLend(2);
            //计划金额（关联借支单金额）
            payPlan.setPlanAmount(compensate);
            //付款金额（支付币种）
            payPlan.setPayPlanAmount(compensate.divide(costPlanDomain.getPayCur(), 4));
            payPlan.setCounteract(BigDecimal.ZERO);
            payPlan.setPayCounteract(BigDecimal.ZERO);
            payPlan.setIsTax(0);
            payPlan.setTypeNo(null);

            payPlan.setCostReason("借支差额：" + payPlan.getSupCostNo());
            costPlanDao.insert(payPlan);
            log.info("生成一张补差额的付款单计划：" + payPlan);

            // 生成空子类的子项目
            CostPlanTempDomain temp = new CostPlanTempDomain();
            temp.setTempNo(costPlanTempService.createNo());
            temp.setCostPlanNo(payPlan.getCostPlanNo());
            temp.setCostReason("借支差额：" + payPlan.getSupCostNo());
            temp.setAmount(payPlan.getPlanAmount());
            temp.setDic(payPlan.getDic());
            temp.setFilePath(costPlanDomain.getFilePath());
            costPlanTempDao.insert(temp);
            log.info("生成差额单子项目 " + temp);

            //更新借支单归还金额
            supCost.setCompensate(supCost.getCompensate().add(payPlan.getPlanAmount()));
            supCost.setLastModifyDate(LocalDateTime.now());
            costDao.updateById(supCost);
        }
    }

    /**
     * 确认归还余额
     *
     * @param costPlanNo costPlanNo
     */
    private void affirmLendBalance(String costPlanNo) {
        CostPlanDomain costPlanDomain = costPlanDao.selectByNo(costPlanNo);

        //已确认
        costPlanDomain.setCostPlanStatus(1);
        costPlanDao.updateById(costPlanDomain);

        //关联的借支单
        CostDomain supCost = costService.getCostByCostNo(costPlanDomain.getSupCostNo());

        //借支还需要还的金额 = 借支单金额 -  借支单已还金额
        BigDecimal subtract = supCost.getAmount().subtract(supCost.getHadPay());
        //借还单余额
        BigDecimal lendBalance = costPlanDomain.getLendBalance();
        if (lendBalance.compareTo(BigDecimal.ZERO) <= 0) {
            return;
        }

        if (lendBalance.compareTo(subtract) > 0) {
            throw new BizRuntimeException("冲销后归还金额 > 借支单待归还金额");
        }

        CostDomain costDomain = planToCost(costPlanDomain.getCostPlanNo());
        costDomain.setCostNo(getCostNo());
        costDomain.setCostStatus(0);
        costDomain.setAmount(costDomain.getLendBalance());
        costDomain.setCounteract(new BigDecimal(0));
        costDomain.setPayPlanAmount(costDomain.getPayLendBalance());
        costDomain.setPayCounteract(new BigDecimal(0));
        BigDecimal toRmbRate1 = CurUtils.getCur(costDomain.getDic(), "CNY");
        costDomain.setToRmbRate(toRmbRate1);
        costDomain.setAmountRmb(costDomain.getAmount().multiply(toRmbRate1).setScale(2, BigDecimal.ROUND_HALF_UP));

        costDao.insert(costDomain);

        //更新借支单申请归还金额
        supCost.setRepaymentAppliedAmount(supCost.getRepaymentAppliedAmount().add(lendBalance));
        supCost.setLastModifyDate(LocalDateTime.now());
        costDao.updateById(supCost);

        log.info("1、冲销 0，还大于0 ==== 生成一张收款的借还单: " + costDomain);
        // 记录日志
        costLogService.save(costDomain.getCostNo(), costDomain.getCreateUserid(), "由费用计划：" + costDomain.getCostPlanNo() + " 生成收款借还单");
    }
}
