package com.blt.other.module.cost.controller;


import com.bailuntec.cost.api.response.CostResult;
import com.blt.other.module.cost.dto.request.TransferReviewReq;
import com.blt.other.module.cost.service.ICostCurrentReviewerService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/**
 * <p>
 * 费用单当前审核人 前端控制器
 * </p>
 *
 * @author robbendev
 * @since 2020-12-16
 */
@Api(tags = "当前审核人接口")
@RestController
@RequestMapping("/costCurrentReviewer")
public class CostCurrentReviewerController {

    @Resource
    ICostCurrentReviewerService costCurrentReviewerService;

    @ApiOperation("转审核")
    @PostMapping("/transferReview")
    public CostResult<Void> transferReview(@RequestBody TransferReviewReq req) {
        costCurrentReviewerService.transferReview(req);
        return CostResult.success();
    }

}
