package com.blt.other.module.auth.controller;


import com.bailuntec.cost.api.response.CostResult;
import com.blt.other.module.auth.model.OaCompany;
import com.blt.other.module.auth.model.OaDepartment;
import com.blt.other.module.auth.service.IOaDepartmentService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

/**
 * <p>
 * 前端控制器
 * </p>
 *
 * @author robbendev
 * @since 2020-10-12
 */
@Api(tags = "oa公司部门接口")
@RestController
@RequestMapping("/oaDepartment")
public class OaDepartmentController {

    @Resource
    IOaDepartmentService oaDepartmentService;

    @ApiOperation("获取公司主体下面的一级部门列表")
    @GetMapping("/primaryDepartment")
    public CostResult<List<OaDepartment>> primaryDepartment(@RequestParam Integer companyId) {
        List<OaDepartment> oaDepartmentList = oaDepartmentService.primaryDepartment(companyId);
        return CostResult.success(oaDepartmentList);
    }

    @ApiOperation("获取一级部门下面的二级部门列表")
    @GetMapping("/secondDepartment")
    public CostResult<List<OaDepartment>> secondDepartment(@RequestParam Integer primaryDepartmentId) {
        List<OaDepartment> oaDepartmentList = oaDepartmentService.secondDepartment(primaryDepartmentId);
        return CostResult.success(oaDepartmentList);
    }


    @ApiOperation("获取公所有部门列表")
    @GetMapping("/allOaDepartment")
    public CostResult<List<OaDepartment>> allOaDepartment() {
        List<OaDepartment> oaDepartmentList = oaDepartmentService.allOaDepartment();
        return CostResult.success(oaDepartmentList);
    }


    @ApiOperation("/查询部门树")
    @GetMapping("/queryTree")
    public CostResult<List<OaCompany>> queryTree() {
        List<OaCompany> oaCompanyList = oaDepartmentService.queryTree();
        return CostResult.success(oaCompanyList);
    }
}
