package com.blt.other.common.config;


import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

/**
 * <p>
 * Swagger2配置类
 * </p>
 *
 * @author robbendev
 */
@Configuration
@EnableSwagger2
public class Swagger2Config {


    @Bean
    public Docket authApi() {
        return new Docket(DocumentationType.SWAGGER_2)
                .groupName("鉴权接口")
                .apiInfo(apiInfo())
                .select()
                .apis(RequestHandlerSelectors.basePackage("com.blt.other.module.auth"))
                .paths(PathSelectors.any())
                .build();
    }

    @Bean
    public Docket commonApi() {
        return new Docket(DocumentationType.SWAGGER_2)
                .groupName("通用接口")
                .apiInfo(apiInfo())
                .select()
                .apis(RequestHandlerSelectors.basePackage("com.blt.other.module.common"))
                .paths(PathSelectors.any())
                .build();
    }


    @Bean
    public Docket costApi() {
        return new Docket(DocumentationType.SWAGGER_2)
                .groupName("费用单接口")
                .apiInfo(apiInfo())
                .select()
                .apis(RequestHandlerSelectors.basePackage("com.blt.other.module.cost"))
                .paths(PathSelectors.any())
                .build();
    }

    @Bean
    public Docket entrepotApi() {
        return new Docket(DocumentationType.SWAGGER_2)
                .groupName("库存接口")
                .apiInfo(apiInfo())
                .select()
                .apis(RequestHandlerSelectors.basePackage("com.blt.other.module.entrepot"))
                .paths(PathSelectors.any())
                .build();
    }

    @Bean
    public Docket purchasingApi() {
        return new Docket(DocumentationType.SWAGGER_2)
                .groupName("采购接口")
                .apiInfo(apiInfo())
                .select()
                .apis(RequestHandlerSelectors.basePackage("com.blt.other.module.purchasing"))
                .paths(PathSelectors.any())
                .build();
    }

    @Bean
    public Docket skuApi() {
        return new Docket(DocumentationType.SWAGGER_2)
                .groupName("sku接口")
                .apiInfo(apiInfo())
                .select()
                .apis(RequestHandlerSelectors.basePackage("com.blt.other.module.sku"))
                .paths(PathSelectors.any())
                .build();
    }

    @Bean
    public Docket supplierApi() {
        return new Docket(DocumentationType.SWAGGER_2)
                .groupName("供应商接口")
                .apiInfo(apiInfo())
                .select()
                .apis(RequestHandlerSelectors.basePackage("com.blt.other.module.supplier"))
                .paths(PathSelectors.any())
                .build();
    }

    @Bean
    public Docket sysApi() {
        return new Docket(DocumentationType.SWAGGER_2)
                .groupName("系统设置接口")
                .apiInfo(apiInfo())
                .select()
                .apis(RequestHandlerSelectors.basePackage("com.blt.other.module.sys"))
                .paths(PathSelectors.any())
                .build();
    }

    /**
     * 创建该API的基本信息（这些基本信息会展现在文档页面中）
     * 访问地址：http://项目实际地址/swagger-ui.html
     *
     * @return
     */
    private ApiInfo apiInfo() {
        return new ApiInfoBuilder()
                .title("费用系统接口文档")
                .description("")
                .termsOfServiceUrl("http://81.71.125.58")
                .version("1.0")
                .build();
    }
}
