package com.bailuntec.cost.api.dto;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/10/29 10:19 上午
 */
@Data
public class CostTemplateDto {


    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty("1-付款单2-收款单 3-借支单 4-借还单")
    private Integer costType;

    @ApiModelProperty(value = "费用单模版名")
    private String templateName;

    @ApiModelProperty("是否开启自动审核")
    private Boolean enableAutoReview;

    @ApiModelProperty("是否开启部门审核")
    private Boolean enableDepartmentReview;

    @ApiModelProperty("是否开启财务自动审核")
    private Boolean enableFinancialAutoReview;

    @ApiModelProperty("是否开启最终人审核")
    private Boolean enableFinalReview;

    @ApiModelProperty("自动审核金额 冗余从表金额字段")
    private BigDecimal autoCheckAmount;

    //    @TableField(exist = false)
    @ApiModelProperty("是否设置了自动审核")
    private Boolean setAutoCheck;

    @ApiModelProperty("最终审核人最低审核金额")
    private BigDecimal finalMinimumReviewAmount;

    @ApiModelProperty("是否默认模版")
    private Boolean isDefault;

    private Integer createUserId;

    private String createUserName;
    @ApiModelProperty(value = "创建时间")
    private LocalDateTime createTime;

    @ApiModelProperty(value = "更新时间")
    private LocalDateTime lastUpdateTime;

    private Integer updateUserId;

    private String updateUserName;

    private List<CostTemplateColDto> costTemplateColList;
}
