package com.blt.other.module.commons.controller;

import com.bailuntec.cost.api.response.CostResult;
import com.blt.other.common.exception.BizRuntimeException;
import com.blt.other.common.util.PathUtil;
import com.blt.other.module.cost.utils.CostFileUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/10/26 2:04 下午
 */
@Api(tags = "文件服务接口")
@RestController
public class FileController {

    @ApiOperation("文件上传接口")
    @PostMapping("/file/upload")
    public CostResult<String> upload(MultipartFile file) {
        /*附件字段*/
        if (file != null) {
            // 文件上传的路径
            String filePath = PathUtil.getBasePath() + PathUtil.getPath("cost/");
            // 调用工具类执行保存，并返回 path
            String path = CostFileUtil.upload(file, filePath);
            return CostResult.success(path);
        }
        throw new BizRuntimeException("文件不能为空");
    }
}
