package com.blt.other.module.sku.service;

import com.blt.other.database.model.SkuKindDomain;

import java.util.List;

public interface SkuKindService {
    /**
     * 保存 sku 大类
     * @param skuKindDomain
     * @return
     */
    Integer saveSkuKind(SkuKindDomain skuKindDomain);

    /**
     * 根据 skuKindNo 获取 sku 小类
     * @param skuKindNo
     * @return
     */
    SkuKindDomain getBySkuKindNo(String skuKindNo);

    /**
     * 根据 skuKindName skuKindNo 获取 sku List
     * @return
     */
    List<SkuKindDomain> getListBySkuKindNameAndSkuTypeNo(String skuKindName, String skuTypeNo);

    /**
     * 获取 sku 小类列表
     * @return
     */
    List<SkuKindDomain> getSkuKindList();

    /**
     * 根据 skuTypeNo 获取 sku 小类
     * @param skuTypeNo
     * @return
     */
    List<SkuKindDomain> getSkuKindListByTypeNo(String skuTypeNo);
}
