package com.blt.other.module.purchasing.service.impl;

import com.blt.other.database.model.PlanSkuTempDomain;
import com.blt.other.database.model.SysProductDomain;
import com.blt.other.module.purchasing.dao.PlanSkuTempDao;
import com.blt.other.module.purchasing.service.PlanSkuTempService;
import com.blt.other.module.sku.dao.SysProductDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

@Service
public class PlanSkuTempServiceImpl implements PlanSkuTempService {

    private static Logger logger = LoggerFactory.getLogger(PlanSkuTempServiceImpl.class);

    @Autowired
    private PlanSkuTempDao planSkuTempDao;

    @Autowired
    private SysProductDao sysProductDao;
    @Override
    public Integer saveToPlanSkuTemp(String no, String skucode, Integer skucount) {

        PlanSkuTempDomain planSkuTempDomain = new PlanSkuTempDomain();
        planSkuTempDomain.setCreatetime(new Date());
        planSkuTempDomain.setSkucount(skucount);
        planSkuTempDomain.setSkucode(skucode);
        planSkuTempDomain.setNo(no);
        SysProductDomain skuMsgBySkucode = sysProductDao.selectByKeyword(skucode).get(0);
        planSkuTempDomain.setSkuname(skuMsgBySkucode.getSkuname());
        planSkuTempDomain.setSkuprice(skuMsgBySkucode.getSkuprice());

        return judgeMethod(planSkuTempDomain);
    }

    // 添加时判断是否已经存在相同的记录
    @Override
    public List<PlanSkuTempDomain> getAllByNo(String no) {
        return planSkuTempDao.selectListByNo(no);
    }

    @Override
    public Integer resetSkuTemp(PlanSkuTempDomain planSkuTempDomain) {
        return planSkuTempDao.updatePlanSkuTemp(planSkuTempDomain);
    }

    @Override
    public PlanSkuTempDomain getTmpByNoAndSkucode(String no, String skucode) {
        PlanSkuTempDomain skuTempDomain = new PlanSkuTempDomain();
        skuTempDomain.setNo(no);
        skuTempDomain.setSkucode(skucode);
        PlanSkuTempDomain result = planSkuTempDao.selectByNoAndSkucode(skuTempDomain);
        if (null != result && null != result.getId()){
            return result;
        }else {
            return null;
        }
    }

    @Override
    public void delete(String no, String skucode) {
        planSkuTempDao.delete(no,skucode);
    }

    private Integer judgeMethod(PlanSkuTempDomain planSkuTempDomain){
        Integer result = null;
        PlanSkuTempDomain judgeResult = planSkuTempDao.selectByNoAndSkucode(planSkuTempDomain);
        if (null == judgeResult){
            result = planSkuTempDao.insertPlanSkuTemp(planSkuTempDomain);
        }else {
            logger.info(planSkuTempDomain.getNo()+" 已经存在 sku 为"+planSkuTempDomain.getSkucode()+" 的添加记录");
//            result = planSkuTempDao.updatePlanSkuTemp(planSkuTempDomain);
        }
        return result;
    }

    /**
     * 保存操作
     * @param planSkuTempDomain
     * @return
     */
    private Integer insertToPlanSkuTemp(PlanSkuTempDomain planSkuTempDomain){
        return planSkuTempDao.insertPlanSkuTemp(planSkuTempDomain);
    }

    /**
     * 修改操作
     * @param planSkuTempDomain
     * @return
     */
    private Integer updateToPlanSkuTemp(PlanSkuTempDomain planSkuTempDomain){
        return planSkuTempDao.updatePlanSkuTemp(planSkuTempDomain);
    }

}
