package com.blt.other.other_cost.utils;

import lombok.extern.slf4j.Slf4j;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.multipart.MultipartFile;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;

/**
 * 费用模块文件上传、下载工具类
 */
@Slf4j
public class CostFileUtil {

    public static String upload(MultipartFile file, String filePath) {

        // 获取文件名
        String fileName = file.getOriginalFilename();

        // fileName处理
        fileName = filePath + UUID.randomUUID() + "&" + fileName;
        // 文件对象
        File dest = new File(fileName);
        // 创建路径
        if (!dest.getParentFile().exists()) {
            dest.getParentFile().mkdirs();
        }
        try {
            file.transferTo(dest);
        } catch (IOException e) {
//            logger.error("affirmFile 发生错误",e);
        }
        return fileName;
    }

    public static String upload(String netUrl, String filePath) throws IOException {

        RestTemplate restTemplate = new RestTemplate();
        byte[] bytes = restTemplate.getForObject(netUrl, byte[].class);
        if (bytes == null || bytes.length == 0) {
            throw new RuntimeException("附件内容为空");
        }

        int dotIndex = netUrl.lastIndexOf(".");

        String fileName = filePath + UUID.randomUUID() + "." + netUrl.substring(dotIndex + 1);

        File dest = new File(fileName);
        // 创建路径
        if (!dest.exists()) {	//文件不存在则创建文件，先创建目录
            File dir = new File(dest.getParent());
            dir.mkdirs();
            dest.createNewFile();
        }
        InputStream inputStream = new FileInputStream(fileName);

        int size = inputStream.read(bytes);
        log.info("文件大小:{}", size);
        inputStream.close();

        return fileName;
    }


}
