package com.blt.other.other_cost.service.impl;

import com.blt.other.other_auth.service.UserService;
import com.blt.other.other_cost.dao.CostCheckSearchDao;
import com.blt.other.other_cost.dto.CostDto;
import com.blt.other.other_cost.service.CostCheckSearchService;
import com.blt.other.other_cost.service.CostListSearchService;
import com.blt.other.other_cost.service.CostService;
import com.blt.other.other_cost.vo.CostCheckSearchKeysVo;
import com.blt.other.other_database.model.CostDomain;
import com.blt.other.other_database.model.UserDomain;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service
public class CostCheckSearchServiceImpl implements CostCheckSearchService {

    @Autowired
    private CostCheckSearchDao costCheckSearchDao;
    @Autowired
    private CostListSearchService costListSearchService;
    @Autowired
    private CostService costService;

    @Override
    public Map<String, Object> getAll(Integer pageNum, Integer pageSize, String authority) {
        PageHelper.startPage(pageNum,pageSize);
        List<CostDomain> costDomains = costCheckSearchDao.selectAll(authority);
        PageInfo<CostDomain> pageInfo = new PageInfo<>(costDomains);
        Map<String,Object> map = new HashMap<>();
        map.put("pageInfo",pageInfo);
        map.put("costs",domainListToDto(costDomains));
        return map;
    }

    public String findAuthorityByUserid(Integer userId) {
        return costCheckSearchDao.findAuthorityByUserid(userId);
    }

    @Override
    public Map<String, Object> seachByKey(String key,int pageNum,int pageSize, String authority) {
        Map<String,Object> map = new HashMap<>();
        PageHelper.startPage(pageNum,pageSize);
        List<CostDomain> costDomains = costCheckSearchDao.selectByKey(key, authority);
        PageInfo<CostDomain> pageInfo = new PageInfo<>(costDomains);
        map.put("costs",domainListToDto(costDomains));
        map.put("pageInfo",pageInfo);
        return map;
    }

    @Override
    public List<CostDto> domainListToDto(List<CostDomain> domains) {
        return costListSearchService.domainListToDto(domains);
    }

    @Override
    public Map<String, Object> searchByKeys(CostCheckSearchKeysVo searchKeysVo) {
        Map<String,Object> map = new HashMap<>();
        PageHelper.startPage(searchKeysVo.getParams().getPageNum(),searchKeysVo.getParams().getPageSize());
        List<CostDomain> costDomains = costCheckSearchDao.selectByKeys(searchKeysVo);
        PageInfo<CostDomain> pageInfo = new PageInfo<>(costDomains);
        if (null != searchKeysVo.getParams().getKeys().getLinkCost() && !searchKeysVo.getParams().getKeys().getLinkCost().isEmpty()){
            List<CostDomain> list = new ArrayList<>();
            CostDomain supCost = costService.getCostDomainByNo(searchKeysVo.getParams().getKeys().getLinkCost());
            list.add(supCost);
            if (null != costDomains && costDomains.size() >= 1){
                for (CostDomain cost: costDomains){
                    list.add(cost);
                }
                costDomains = list;
            }
        }
        map.put("costs",domainListToDto(costDomains));
        map.put("pageInfo",pageInfo);
        return map;
    }

    @Override
    public List<CostDomain> getLinkCost() {
        return costCheckSearchDao.selectLinkList();
    }
}
