package com.blt.other.other_cost.service;

import com.blt.other.other_cost.dto.CostDto;
import com.blt.other.other_cost.vo.CostExportVo;
import com.blt.other.other_database.model.CostDomain;

import java.util.List;
import java.util.Map;

public interface CostService {

    /**
     * 保存新费用单
     * @param costDomain
     * @return
     */
    Integer saveNewCost(CostDomain costDomain);

    /**
     * 获取所有费用单
     * @return
     */
    Map<String, Object> getAllCost(Integer pageNum,Integer pageSize, Integer userId,String projectTypes);

    /**
     * 根据 costNo 获取 cost
     * @param costNo
     * @return
     */
    Map<String,Object> getCostByCostNo(String costNo);

    /**
     * 修改费用单信息
     * @param costDomain
     * @return
     */
    Map<String,Object> upadateCost(CostDomain costDomain);


    /**
     * 获取 status >= costStatus(param) 的费用单
     * @param pageNum
     * @param pageSize
     * @param costStatus
     * @return
     */
    Map<String,Object> getCostByStatus(Integer pageNum,Integer pageSize,Integer costStatus);

    /**
     * 根据 costNo 获取 costDomain
     * @param costNo
     * @return
     */
    CostDomain getCostDomainByNo(String costNo);

    /**
     * 根据 costNo 获取 costDto
     * @param costNo
     * @return
     */
    CostDto getCostDtoByNo(String costNo);

    /**
     * 根据借支类型获取费用单
     * @param isLend
     * @return
     */
    List<CostDto> getCostByLend(Integer isLend);

    Map<String, Object> getByStatu(Integer pageNum, Integer pageSize, Integer costStatus);

    Map<String,Object> getByLendStatu(Integer pageNum, Integer pageSize, Integer lendStatus);

    Map<String,Object> getByCostForm(Integer pageNum, Integer pageSize, Integer costForm);

    Map<String,Object> getByCostFormAndStatus(Integer pageNum, Integer pageSize, Integer costForm,Integer costStatus);

    Map<String,Object> getByIsLend(Integer pageNum, Integer pageSize, Integer isLend);

    Map<String,Object> getBySupCostNo(Integer pageNum, Integer pageSize, String supCostNo);

    Map<String,Object> getByKeys(Integer pageNum, Integer pageSize, CostDomain costDomain);

    Map<String,Object> getByKey(Integer pageNum, Integer pageSize, String searchKey,Integer costStatus);

    Map<String,Object> getByLendAndStatus(Integer pageNum, Integer pageSize, Integer isLend,Integer costStatus);

    List<CostDto> getByCostPlanNo(String costPlanNo);

    void resetCost(String costNo);

    Integer setStatus(String costNo, int i);

    Integer updateById(CostDomain costDomain);

    CostDomain getByNo(String costNo);

    CostDomain getLastCost();

    List<CostDto> getLinkLendCost(Integer createuserid);

    Integer getCostStatusByNo(String costNo);

    List<CostDto> getCostByRejectStatus();

    List<String> listCostNo();
    List<String> listCostNoAll(CostExportVo costExportVo);

    Integer updateCashierAnnex(String costNo, String filePath, String downloadUrl);
}
