package com.blt.other.module.purchasing.service.impl;

import com.bailuntec.cost.api.domain.BuyDomain;
import com.blt.other.module.purchasing.dao.BuySearchDao;
import com.blt.other.module.purchasing.dto.BuyListDto;
import com.blt.other.module.purchasing.service.BuySearchService;
import com.blt.other.module.purchasing.service.BuyService;
import com.blt.other.module.purchasing.vo.PurcharseListSearchKeysVo;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service
public class BuySearchServiceImpl implements BuySearchService {
    @Autowired
    private BuySearchDao buySearchDao;
    @Autowired
    private BuyService buyService;
    /**
     * 根据关键字查询
     * @param searchKey
     * @return
     */
    @Override
    public List<BuyListDto> getByKey(String searchKey) {
        List<BuyDomain> list = buySearchDao.selectByKey(searchKey);
        List<BuyListDto> dtoList = buyService.getDtoList(list);
        return dtoList;
    }

    /**
     * 根据关键字查询（分页）
     * @param searchKey
     * @return
     */
    @Override
    public Map<String, Object> searchByKey(String searchKey, int pageNum, int pageSize) {
        PageHelper.startPage(pageNum,pageSize);
        List<BuyDomain> list = buySearchDao.selectByKey(searchKey);
        List<BuyListDto> dtoList = buyService.getDtoList(list);
        PageInfo<BuyDomain> pageInfo = new PageInfo<>(list);
        Map<String,Object> result = new HashMap<>();
        result.put("buys",dtoList);
        result.put("pageInfo",pageInfo);

        return result;
    }

    @Override
    public Map<String, Object> searchByKeys(PurcharseListSearchKeysVo keysVo) {
        PageHelper.startPage(keysVo.getPageNum(),keysVo.getPageSize());
        List<BuyDomain> list = buySearchDao.selectByKeys(keysVo);
        List<BuyListDto> dtoList = buyService.getDtoList(list);
        PageInfo<BuyDomain> pageInfo = new PageInfo<>(list);
        Map<String,Object> result = new HashMap<>();
        result.put("buys",dtoList);
        result.put("pageInfo",pageInfo);

        return result;
    }
}
