# 百伦费用系统
百伦内部费用系统

## 一、如何使用

### 1.1 项目架构
`api.fee.bailuntec.com` -> `nginx(193.112.167.175)` -> `java api(193.112.167.175)`

### 1.2 java应用主要三方库
- springboot 
- mybatis
- mybatis plus 


### 1.3 云服务器
正式环境：IP：193.112.167.175:22  ubuntu 密码：!@#blt*nix123  
测试环境：腾讯云k8s(bailun)/blt-cost/bailuntec-cost
### 1.4 nginx

```shell script
docker run \
-it -d \
--name nginx \
-v /etc/nginx/nginx.conf:/etc/nginx/nginx.conf \
-v /srv:/srv \
-v /home/bailuntec:/home/bailuntec \
--privileged=true \
--net=host nginx
```

### 1.5 Java发布
正式环境发布：
```shell script
sh deploy-cost-prod.sh
```
测试环境发布
IDEA docker 插件发布或者用腾讯云coding(见项目Jenkinsfile) 

### 1.6 文档地址
[费用系统线正式环境api](http://api.fee.bailuntec.com/purchase/other/doc.html)  
[费用系统测试环境api](http://api.test.fee.bailuntec.com/purchase/other/doc.html)

### 1.7 其他
费用系统前端位置：/srv/www/otherweb  
费用系统Jar包位置：/home/ubuntu/bailuntec-cost/cost-service/target
费用系统存放文件位置：/home/bailuntec/other  
费用系统日志路径：/home/ubuntu/bailuntec-cost/cost-service/log

## 二、项目结构
cost-interfaces 模块
```
cost-interfaces/src/main/java/
└── com
    └── bailuntec
        ├── auth
        │   └── api
        │       ├── request
        │       └── response
        ├── commons
        │   └── api
        └── cost
            └── api             //暴露给外部的接口
                ├── dto         //应用数据对象
                ├── request     //API 入参
                └── response    //API 出参

```
cost-service 模块
```
cost-interfaces/src/main/java/
└── com
    └── bailuntec
        ├── auth
        │   └── api
        │       ├── request
        │       └── response
        ├── commons
        │   └── api
        └── cost
            └── api
                ├── domain
                ├── dto
                ├── request
                └── response

14 directories
huluobindeMacBook-Pro:bailuntec-cost huluobin$ 
huluobindeMacBook-Pro:bailuntec-cost huluobin$ 
huluobindeMacBook-Pro:bailuntec-cost huluobin$ tree -d cost-service/src/main/java/
cost-service/src/main/java/
└── com
    └── blt
        └── other
            ├── common                  //应用通用类库
            │   ├── annotation          //自定义注解
            │   ├── base                //通用父类
            │   ├── config              //应用配置
            │   │   └── property        //应用属性
            │   ├── exception           //应用异常和全局异常处理
            │   ├── filter              //过滤器
            │   ├── interceptor         //拦截器
            │   │   └── mail            //邮件服务 
            │   │       └── impl
            │   ├── job                 //应用定时任务
            │   ├── lock                //锁的应用实现
            │   ├── util                //应用工具类
            │   └── wrapper             //备份流
            ├── database                //遗留模块
            │   ├── mapper
            │   ├── model
            │   └── service
            └── module   //具体应用模块
                ├── cost
                │   ├── controller      //rest接口
                │   ├── dao             //dao层
                │   ├── dto             //数据传输对象 有些没放到interfaces模块的懒得移过去了
                │   │   ├── request
                │   │   └── response
                │   ├── model           //实体领域对象
                │   ├── service         //服务层
                │   │   └── impl
                │   │       ├── cost
                │   │       ├── costcheck
                │   │       └── costplan
                │   ├── utils            //一些模块工具类
                │   └── vo              //值对象
                ...
```


## 三、如何开发

一个新的表如何开发接口

### 3.1 代码生成器
位置: bailuntec-cost/cost-service/src/test/com/blt/other/CodeGenerator.java  
根据命令行提示输入模块名和表名

### 3.2 controller开发
controller
```java
@Api(tags = "oa公司主体接口")
@RestController
@RequestMapping("/oaCompany")
public class OaCompanyController {


    @Resource
    IOaCompanyService oaCompanyService;

    @ApiOperation("获取百伦公司主体")
    @GetMapping("/oaCompanyList")
    public CostResult<List<OaCompany>> oaCompanyList() {
        List<OaCompany> oaCompanyList = oaCompanyService.oaCompanyList();
        return CostResult.success(oaCompanyList);
    }
}
```

### 3.3 service

接口
```java
public interface IOaCompanyService extends IService<OaCompany> {

    /**
     * <p>
     * 获取百伦公司主体
     * </p>
     *
     * @return 百伦公司主体
     */
    List<OaCompany> oaCompanyList();
}
```
实现
```java
@Service
public class OaCompanyServiceImpl extends ServiceImpl<OaCompanyMapper, OaCompany> implements IOaCompanyService {

    @Resource
    CostReviewerMapper costReviewerMapper;

    @Override
    public List<OaCompany> oaCompanyList() {
        return this.list();
    }
    //...
}
```

### 3.4 mapper
```java
public interface OaCompanyMapper extends BaseMapper<OaCompany> {
    //...
}
```

### 3.5 异常处理
直接在业务代码向上抛异常，全局异常处理会处理。
```java

@ControllerAdvice
@ResponseBody
@Slf4j
public class GlobalExceptionHandler {

    /**
     * 自定义异常
     */
    @ResponseBody
    @ExceptionHandler(BizRuntimeException.class)
    public Map<String, Object> handleBizRuntimeException(HttpServletRequest request,
                                                         BizRuntimeException e) {
        Map<String, Object> result = new HashMap<>();
        result.put("success", false);
        result.put("msg", e.getMessage());
        result.put("message", e.getMessage());
        result.put("code", e.getCode());

        log.error(e.getMessage(), e);
        return result;
    }
    //...
}
```

### 3.6 通用返回结果
```java
@Data
public class CostResult<T> {
    private String message;
    private Boolean success;
    private T data;

    private String code;
    // ...
}
```
