package com.blt.other.other_auth.service.impl;

import com.blt.other.other_auth.service.UserSyncService;
import com.blt.other.other_auth.vo.GetByBLUserAcct;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.List;

@Service
public class UserSyncServiceImpl implements UserSyncService {

    private static Logger logger = LoggerFactory.getLogger(UserSyncServiceImpl.class);

    @Autowired
    private RestTemplate restTemplate;

    @Value("${url.api.logingUserApi}")
    private String logingUserApi;
    @Value("${url.api.buyUserApi}")
    private String buyUserApi;

    @Override
    public GetByBLUserAcct getUserByCookie(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        String BLUserAcct = null;

        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if ("BLUserAcct".equals(cookie.getName())) {
                    BLUserAcct = cookie.getValue();
                }
            }
        }

        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        MultiValueMap<String, String> params= new LinkedMultiValueMap<String, String>();
        params.add("BLUserAcct",BLUserAcct);
        HttpEntity<MultiValueMap<String, String>> httpEntity = new HttpEntity<MultiValueMap<String, String>>(params, headers);
        ResponseEntity<String> response = restTemplate.postForEntity(logingUserApi, httpEntity, String.class);


        ObjectMapper mapper = new ObjectMapper();
        String strBody = null;
        if (response != null && response.getStatusCodeValue() == 200) {
            strBody = response.getBody();
        } else {
            logger.error("UserSyncServiceImpl",response);
            return null;
        }
        strBody=strBody.toLowerCase();
        logger.info("从 oa 系统获取登陆用户信息："+strBody);
        GetByBLUserAcct getByBLUserAcct = null;
        try {
            getByBLUserAcct = mapper.readValue(strBody, GetByBLUserAcct.class);
        } catch (IOException e) {
            logger.error(strBody+"转换失败",e.getMessage());
        }
        return getByBLUserAcct;
    }
}
