package com.blt.other.module.cost.service.impl.cost;

import com.alibaba.fastjson.JSON;
import com.bailuntec.api.bailuntec.cw.CwApi;
import com.bailuntec.common.JsonUtilByFsJson;
import com.bailuntec.common.JsonUtilByJackson;
import com.bailuntec.common.ListUtil;
import com.bailuntec.common.StringUtils;
import com.bailuntec.cost.api.dto.CostDto;
import com.bailuntec.cost.api.dto.CostListPrintDto;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.blt.other.common.config.property.CostUrlProperties;
import com.blt.other.common.exception.BizRuntimeException;
import com.blt.other.common.util.CurUtils;
import com.blt.other.common.util.SessionUtils;
import com.blt.other.database.model.CostApplycallbackDomain;
import com.blt.other.database.model.CostCashiercallbackDomain;
import com.blt.other.database.model.CostTypeDomain;
import com.blt.other.database.model.UserDomain;
import com.blt.other.module.auth.dao.OaDepartmentMapper;
import com.blt.other.module.auth.dao.OaUserMapper;
import com.blt.other.module.auth.model.OaDepartment;
import com.blt.other.module.auth.model.OaUser;
import com.blt.other.module.cost.dao.*;
import com.blt.other.module.cost.dto.request.AllCheckCostListReq;
import com.blt.other.module.cost.dto.request.CheckCostListReq;
import com.blt.other.module.cost.dto.request.CostQueryPageReq;
import com.blt.other.module.cost.dto.response.CostTypeResult;
import com.blt.other.module.cost.dto.response.UpdateCostResp;
import com.blt.other.module.cost.model.*;
import com.blt.other.module.cost.service.*;
import com.blt.other.module.cost.vo.ApplyCallbackUrlDataDataVo;
import com.blt.other.module.cost.vo.ApplyCallbackUrlVo;
import com.blt.other.module.cost.vo.CashierCallbackUrlDataDataVo;
import com.blt.other.module.cost.vo.CashierCallbackUrlVo;
import com.blt.other.module.netsuite.dao.NetsuiteLogDao;
import com.blt.other.module.netsuite.dto.NetsuiCostinfoDto;
import com.blt.other.module.netsuite.dto.NetsuiteDataDto;
import com.blt.other.module.netsuite.model.NetsuiteLogDomain;
import com.blt.other.module.sys.model.CostReviewer;
import com.blt.other.module.sys.service.UserService;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.*;
import java.util.stream.Collectors;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/10/29 11:35 上午
 */
@Slf4j
public abstract class AbstractCostService implements CostService {

    @Autowired
    CwApi cwApi;
    @Autowired
    CostTofinanceService costTofinanceService;
    @Resource
    CostDao costDao;
    @Autowired
    UserService userService;
    @Autowired
    ICostTemplateService costTemplateService;
    @Autowired
    CostCompanyDao costCompanyDao;
    @Autowired
    CostDetailDao costDetailDao;
    @Autowired
    CostLogService costLogService;
    @Resource
    CostUrlProperties costUrlProperties;
    @Resource
    OaDepartmentMapper oaDepartmentMapper;
    @Resource
    NetsuiteLogDao netsuiteLogDao;

    @Override
    public void setPrimaryDepartment(List<CostDomain> costDomains) {
        if (ListUtil.isEmpty(costDomains)) {
            return;
        }
        List<OaUser> oaUserList = oaUserMapper.selectList(new LambdaQueryWrapper<OaUser>()
                .in(OaUser::getOaUserId, costDomains.stream().map(CostDomain::getCreateUserid).collect(Collectors.toList()))
        );
        if (ListUtil.isNotEmpty(oaUserList)) {
            Map<Integer, OaDepartment> departmentMap = oaDepartmentMapper.selectList(
                    new LambdaQueryWrapper<OaDepartment>()
                            .in(OaDepartment::getDepartmentId, oaUserList.stream()
                                    .map(OaUser::getPrimaryDepartmentId)
                                    .filter(Objects::nonNull)
                                    .collect(Collectors.toList())))
                    .stream()
                    .collect(Collectors.toMap(OaDepartment::getDepartmentId, oaDepartment -> oaDepartment));

            Map<Integer, OaUser> oaUserMap = oaUserList.stream()
                    .peek(oaUser -> oaUser.setPrimaryDepartment(departmentMap.get(oaUser.getPrimaryDepartmentId())))
                    .collect(Collectors.toMap(OaUser::getOaUserId, oaUser -> oaUser));

            costDomains.forEach(costDomain -> {
                OaUser oaUser = oaUserMap.get(costDomain.getCreateUserid());
                if (oaUser != null) {
                    costDomain.setPrimaryDepartmentId(oaUserMap.get(costDomain.getCreateUserid()).getPrimaryDepartmentId());
                    costDomain.setPrimaryDepartmentName(oaUserMap.get(costDomain.getCreateUserid()).getPrimaryDepartment().getName());
                }
            });
        }
    }

    @Resource
    OaUserMapper oaUserMapper;
    @Resource
    ICostCurrentReviewerService costCurrentReviewerService;

    @Override
    public CostDomain getCostByCostNo(String costNo) {
        CostDomain costDomain = costDao.selectByCostNo(costNo);
        if (costDomain == null) {
            return null;
        }
        costDomain.setCostTemplate(costTemplateService.queryDetail(costDomain.getCostTemplateId()));

        Integer currentUserId = SessionUtils.getCurrentUserId();
        if (currentUserId == null) {
            currentUserId = costDomain.getCreateUserid();
        }

        costDomain.setCanAudit(costCurrentReviewerService.canAudit(currentUserId, costNo));

        List<CostDetailDomain> costDetailDomainList = costDetailDao.selectListByCostNo(costNo);
        costDomain.setCostDetailDomainList(costDetailDomainList);

        return costDomain;
    }

    @Resource
    CostTemplateBaseColMapper costTemplateBaseColMapper;
    @Resource
    AccountingSubjectMapper accountingSubjectMapper;
    @Resource
    CostTypeDao costTypeDao;

    @Transactional(rollbackFor = Exception.class)
    @Override
    public UpdateCostResp updateCost(CostDomain input) {
        CostDomain costDomain = new CostDomain();
        BeanUtils.copyProperties(input, costDomain, "id", "createUserid", "createUsername", "createUsercode", "createTime");
        UpdateCostResp resp = new UpdateCostResp();

        if (null != costDomain.getCompanyNo()) {
            costDomain.setCompanyName(costCompanyDao.selectByNo(costDomain.getCompanyNo()).getCompanyName());
        }
        if (ListUtil.isNotEmpty(costDomain.getAttach())) {
            costDomain.getAttach().forEach(costAttach -> {
                CostTemplateBaseCol costTemplateBaseCol = costTemplateBaseColMapper.selectById(costAttach.getCostTemplateBaseColId());
                BeanUtils.copyProperties(costTemplateBaseCol, costAttach, "id");
            });
        }

        costDomain.setLastModifyDate(LocalDateTime.now());
        if (costDomain.getCostForm() != 1) {
            BigDecimal toRmbRate = CurUtils.getCur(costDomain.getDic(), "CNY");
            costDomain.setToRmbRate(toRmbRate);
            costDomain.setAmountRmb(costDomain.getAmount().multiply(toRmbRate).setScale(2, BigDecimal.ROUND_HALF_UP));
        } else {
            CostDomain oldCostDomain = this.getCostByCostNo(costDomain.getCostNo());
            if (oldCostDomain != null) {
                costDomain.setToRmbRate(oldCostDomain.getToRmbRate());
                costDomain.setAmountRmb(oldCostDomain.getAmountRmb());
            } else {
                throw new BizRuntimeException("修改费用单异常,请重试!");
            }
        }
        if (StringUtils.isNotEmpty(costDomain.getTypeNo())) {

            CostTypeDomain costTypeDomain = costTypeDao.selectByNo(costDomain.getTypeNo());
            if (costTypeDomain != null) {
                AccountingSubject accountingSubject = accountingSubjectMapper.selectById(costTypeDomain.getAccountingSubjectId());

                if (accountingSubject != null) {
                    costDomain.setTypeNo(costDomain.getTypeNo());
                    costDomain.setTypeName(costTypeDomain.getTypeName());
                    costDomain.setCategoryName(StringUtils.isNotBlank(costTypeDomain.getCategoryName()) ? costTypeDomain.getCategoryName() : costDomain.getTypeName());
                    costDomain.setAccountingSubjectNo(accountingSubject.getSubjectNo());
                    costDomain.setAccountingSubjectName(accountingSubject.getName());
                }
            }
        }

        Integer update = costDao.update(costDomain, new LambdaQueryWrapper<CostDomain>()
                .eq(CostDomain::getCostNo, costDomain.getCostNo()));

        //费用单明细
        if (costDomain.getCostDetailDomainList() != null && costDomain.getCostDetailDomainList().size() > 0) {
            costDetailDao.delete(new LambdaQueryWrapper<CostDetailDomain>()
                    .eq(CostDetailDomain::getCostNo, costDomain.getCostNo())
            );
            for (int i = 0; i < costDomain.getCostDetailDomainList().size(); i++) {
                CostDetailDomain costDetailDomain = costDomain.getCostDetailDomainList().get(i);
                CostDetailDomain detailDomain = new CostDetailDomain();
                BeanUtils.copyProperties(costDomain, detailDomain);
                BeanUtils.copyProperties(costDetailDomain, detailDomain);
                detailDomain.setDetailNo(costDomain.getCostNo() + "-" + (i + 1));
                costDetailDao.insert(detailDomain);
            }
        }

        resp.setMsg("success");
        resp.setResult(this.getCostByCostNo(costDomain.getCostNo()));
        resp.setUpdate(update);
        return resp;

    }


    @Override
    public List<CostDto> getByCostPlanNo(String costPlanNo) {
        return costDao.selectByCostPlanNo(costPlanNo)
                .stream()
                .map(CostDomain::castToDto)
                .collect(Collectors.toList());
    }

    @Override
    public void resetCost(String costNo) {
        List<CostDetailDomain> costDetailDomains = costDetailDao.selectListByCostNo(costNo);
        CostDetailDomain costDetailDomain = costDetailDomains.get(0);

        if (costDetailDomains.stream().collect(Collectors.groupingBy(CostDetailDomain::getDic)).keySet().size() > 1) {
            throw new RuntimeException("请统一货币单位");
        }
        if (costDetailDomains.stream().collect(Collectors.groupingBy(CostDetailDomain::getTypeId)).keySet().size() > 1) {
            throw new RuntimeException("请统一费用类型");
        }

        CostDomain costDomain = this.getCostByCostNo(costNo);
        costDomain.setAmount(costDetailDomains.stream().map(CostDetailDomain::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add));

        BigDecimal toRmbRate = CurUtils.getCur(costDomain.getDic(), "CNY");
        costDomain.setToRmbRate(toRmbRate);
        costDomain.setAmountRmb(costDomain.getAmount().multiply(toRmbRate).setScale(2, BigDecimal.ROUND_HALF_UP));

        CostTypeDomain costTypeDomain = costTypeDao.selectById(costDetailDomain.getTypeId());
        costDomain.setCostType(costTypeDomain);

        costDomain.setLastModifyDate(LocalDateTime.now());
        if (StringUtils.isBlank(costTypeDomain.getCategoryName())) {
            costDomain.setCategoryName(costDomain.getTypeName());
        }

        costDao.updateById(costDomain);
    }

    @Override
    public Integer setStatus(String costNo, int i) {
        CostDomain costDomain = new CostDomain();
        costDomain.setCostNo(costNo);
        costDomain.setCostStatus(i);
        costDomain.setLastModifyDate(LocalDateTime.now());
        if (costDomain.getCostStatus().equals(5)) {
            //释放已申请的金额
            CostDomain supCost = this.getCostByCostNo(costDomain.getSupCostNo());

            if (supCost != null) {
                supCost.setRepaymentAppliedAmount(supCost.getRepaymentAppliedAmount().subtract(costDomain.getAmount()));
                supCost.setLastModifyDate(LocalDateTime.now());
                costDao.updateById(supCost);
            }
        }
        return costDao.update(costDomain, new LambdaQueryWrapper<CostDomain>()
                .eq(CostDomain::getCostNo, costDomain.getCostNo()));
    }

    @Override
    public Integer updateById(CostDomain costDomain) {
        costDomain.setLastModifyDate(LocalDateTime.now());
        return costDao.updateById(costDomain);
    }

    @Override
    public void updateCashierAnnex(String costNo, String filePath, String downloadUrl) {
        CostDomain costDomain = this.getCostByCostNo(costNo);
        costDomain.setCashierFilePath(filePath);
        costDomain.setCashierDownloadPath(downloadUrl);
        costDomain.setLastModifyDate(LocalDateTime.now());
        costDao.updateById(costDomain);
    }

    @Override
    public List<CostListPrintDto> printList(List<String> printNos) {
        return printNos.stream().map(costNo -> this.getCostByCostNo(costNo).printDto()).collect(Collectors.toList());
    }

    @Transactional
    @Override
    public IPage<CostDto> checkCostList(CheckCostListReq req) {

        IPage<CostDomain> page = new Page<>(req.getPageNum(), req.getPageSize());
        //需要财务审核或者需要我最终审核费用列表查询
        if (req.getType().equals(1)) {
            return costDao.financialOrFinalCheckCostList(page, req).convert(CostDomain::castToDto);
        }
        if (req.getType().equals(2)) {
            //所有需要部门审核 + 部门审核通过 费用列表查询
            if (req.getStatus().equals(1)) {
                return costDao.departmentCheckAllCostList(page, req).convert(CostDomain::castToDto);
            }
            //需要我部门审核费用列表查询
            if (req.getStatus().equals(2)) {
                return costDao.departmentCheckCostList(page, req).convert(CostDomain::castToDto);
            }
            //已经部门手动审核费用列表查询
            if (req.getStatus().equals(3)) {
                return costDao.departmentManualCheckLllCostList(page, req).convert(CostDomain::castToDto);
            }
            //已经部门自动核费用列表查询
            if (req.getStatus().equals(4)) {
                return costDao.departmentAutoCheckLllCostList(page, req).convert(CostDomain::castToDto);
            }
        }
        //需要我人事审核费用列表查询
        if (req.getType().equals(3)) {
            return costDao.hrCheckCostList(page, req).convert(CostDomain::castToDto);
        }
        //需要总经办审核
        if (req.getType().equals(4)) {
            return costDao.generalManagerCheckCostList(page, req).convert(CostDomain::castToDto);
        }
        //需要工厂流程审核
        if (req.getType().equals(5)) {
            return costDao.factoryCheckCostList(page, req).convert(CostDomain::castToDto);
        }
        throw new BizRuntimeException("invalid param");
    }

    @Override
    public IPage<CostDto> checkCostAllList(AllCheckCostListReq req) {
        if (req.getCostForm() != null) {
            if (req.getCostForm().equals(3)) {
                req.setIsLend(1);
            }
            if (req.getCostForm().equals(4)) {
                req.setCostForm(3);
                req.setIsLend(2);
            }
        }
        if (req.getCostStatusList() != null && !req.getCostStatusList().isEmpty()) {
            req.setCostStatusStr(StringUtils.join(req.getCostStatusList(), ','));
        }
        IPage<CostDomain> page = new Page<>(req.getPageNum(), req.getPageSize());
        return costDao.allCheckCostList(page, req).convert(CostDomain::castToDto);
    }

    @Resource
    CostApplycallbackService costApplycallbackService;

    @Override
    public void applyCallback(ApplyCallbackUrlVo applyCallbackUrlVo) {
        // 执行保存反馈信息流程
        CostApplycallbackDomain applyCallbackDomain = new CostApplycallbackDomain();

        ApplyCallbackUrlDataDataVo applyCallbackUrlDataDataVo = JsonUtilByJackson.readValue(
                applyCallbackUrlVo.getData().getData().replaceAll("/^['|\"](.*)['|\"]$/", ""),
                ApplyCallbackUrlDataDataVo.class
        );

        BeanUtils.copyProperties(applyCallbackUrlDataDataVo, applyCallbackDomain);
        String costNo = applyCallbackUrlVo.getId().toUpperCase();
        if (costNo.contains("-")) {
            costNo = costNo.split("-")[0];
        }
        applyCallbackDomain.setCostNo(costNo);
        if (com.bailuntec.common.StringUtils.isNotEmpty(applyCallbackUrlVo.getData().getMessage())) {
            applyCallbackDomain.setMessage(applyCallbackUrlVo.getData().getMessage().toUpperCase());
        }
        applyCallbackDomain.setApplyno(applyCallbackDomain.getApplyno().toUpperCase());
        costApplycallbackService.saveApplycallbackResponse(applyCallbackDomain);

        log.info("保存财务审核信息成功：");
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public void cashierCallback(CashierCallbackUrlVo cashierCallbackUrlVo) {


        CostCashiercallbackDomain costCashiercallbackDomain = new CostCashiercallbackDomain();
        CashierCallbackUrlDataDataVo cashierCallbackUrlDataDataVo = JsonUtilByFsJson.jsonToBean(
                cashierCallbackUrlVo.getData().getData().replaceAll("/^['|\"](.*)['|\"]$/", ""),
                CashierCallbackUrlDataDataVo.class
        );

        BeanUtils.copyProperties(cashierCallbackUrlVo.getData(), costCashiercallbackDomain);
        BeanUtils.copyProperties(cashierCallbackUrlDataDataVo, costCashiercallbackDomain);
        BeanUtils.copyProperties(cashierCallbackUrlDataDataVo.getPaydetail(), costCashiercallbackDomain);

        String costNo = cashierCallbackUrlVo.getId().toUpperCase();
        if (costNo.contains("-")) {
            String[] split = costNo.split("-");
            costNo = split[0];
        }
        costCashiercallbackDomain.setCostNo(costNo);
        if (com.bailuntec.common.StringUtils.isNotEmpty(costCashiercallbackDomain.getMessage())) {
            costCashiercallbackDomain.setMessage(costCashiercallbackDomain.getMessage().toUpperCase());
        }

        costCashiercallbackDomain.setPayno(costCashiercallbackDomain.getPayno().toUpperCase());


        CostDomain costDomain = this.getCostByCostNo(costNo);
        //
        if (!costDomain.getCostStatus().equals(CostDomain.STATUS_UN_PAY)) {
            return;
        }

        //驳回
        if (costCashiercallbackDomain.getMessage().contains("被驳回")) {
            this.cashierCallbackReject(costCashiercallbackDomain);
        }
        //通过
        else {
            //netsuite保存一份,只保存香港百伦
            this.saveNetsuiteJob(costDomain, costCashiercallbackDomain);

            this.cashierCallbackPass(costCashiercallbackDomain);
        }
    }

    void saveNetsuiteJob(CostDomain costDomain, CostCashiercallbackDomain costCashiercallbackDomain) {
        if (costDomain == null) {
            return;
        }
        //只保存香港百伦
        Integer companyValue = costDomain.getCompanyValue();
        if (companyValue != null && companyValue == 2) {
            //xgbl代表香港百伦
            String companyCode = "xgbl";

            CostTypeResult costTypeResult = costTypeDao.queryDetail(costDomain.getTypeId());

            String nsAccountingSubjectId = costCashiercallbackDomain.getErpAccountingType();

            if (costCashiercallbackDomain.getCashierbankcardname().equals("Hang Seng Bank Limited")
                    && costCashiercallbackDomain.getCashierbankcard().equals("774-515290-883")) {
                switch (costCashiercallbackDomain.getCashierunitcode().toUpperCase()) {
                    case "HKD":
                        nsAccountingSubjectId = "10020201";
                        break;
                    case "EUR":
                        nsAccountingSubjectId = "10020202";
                        break;
                    case "USD":
                        nsAccountingSubjectId = "10020203";
                        break;
                    case "GBP":
                        nsAccountingSubjectId = "10020204";
                        break;
                    case "CNY":
                        nsAccountingSubjectId = "10020205";
                        break;
                    case "AUD":
                        nsAccountingSubjectId = "10020207";
                        break;
                }
            }

            SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
            NetsuiteDataDto netsuiteDataDto = new NetsuiteDataDto();
            netsuiteDataDto.setTranid(costDomain.getCostNo());
            netsuiteDataDto.setCurrency(costCashiercallbackDomain.getCashierunitcode().toUpperCase());
            netsuiteDataDto.setSubsidiary(companyCode);
            if (costCashiercallbackDomain.getActualTime() != null) {
                netsuiteDataDto.setTrandate(sdf.format(costCashiercallbackDomain.getActualTime()));
            }
            netsuiteDataDto.setCustbody_iofeetype(costDomain.getCostForm().toString());

            //费用详情
            List<NetsuiCostinfoDto> netsuiCostInfoDtos = new ArrayList<>();
            //费用系统信息
            NetsuiCostinfoDto feeSysInfo = new NetsuiCostinfoDto(
                    costTypeResult.getNsAccountingSubjectId() != null ? costTypeResult.getNsAccountingSubjectId().toString() : "0",
                    costDomain.getAmount().toString(),
                    costDomain.getCostReason()
            );
            netsuiCostInfoDtos.add(feeSysInfo);
            //财务系统信息
            NetsuiCostinfoDto cwSysInfo = new NetsuiCostinfoDto(
                    nsAccountingSubjectId,
                    costCashiercallbackDomain.getPayamount().toString(),
                    costCashiercallbackDomain.getPaynote()
            );
            netsuiCostInfoDtos.add(cwSysInfo);

            netsuiteDataDto.setCostinfo(netsuiCostInfoDtos);
            NetsuiteLogDomain netsuiteLogDomain = new NetsuiteLogDomain();
            netsuiteLogDomain.setCostNo(costDomain.getCostNo());
            netsuiteLogDomain.setPublishStatus(NetsuiteLogDomain.UNPUBLISH);
            netsuiteLogDomain.setScript(NetsuiteLogDomain.SCRIPT_FEE);
            netsuiteLogDomain.setJsonStr(JSON.toJSONString(netsuiteDataDto));
            netsuiteLogDao.upsert(netsuiteLogDomain);
        }
    }

    @Override
    public void reject(String costNo) {

        if (costNo.startsWith("S")) {
            //费用计划
            CostDomain costDomain = this.getCostByCostNo(costNo);
            //费用计划关联借支单
            CostDomain supCost = this.getCostByCostNo(costDomain.getSupCostNo());
            supCost.setCompensate(supCost.getCompensate().subtract(costDomain.getAmount()));
            costDomain.setLastModifyDate(LocalDateTime.now());
            costDao.updateById(supCost);
        }


        CostDomain costDomain = this.getCostByCostNo(costNo);
        costDomain.setCostStatus(CostDomain.STATUS_REJECT);
        costDomain.setLastModifyDate(LocalDateTime.now());
        costDao.updateById(costDomain);

        costCurrentReviewerService.remove(new LambdaQueryWrapper<CostCurrentReviewer>()
                .eq(CostCurrentReviewer::getCostNo, costDomain.getCostNo()));
    }

    @Override
    public Page<CostDomain> queryPage(CostQueryPageReq req) {
        if (com.bailuntec.common.StringUtils.isNotEmpty(req.getKey())) {
            req.setKeys(Lists.newArrayList(req.getKey().split(",")));
        }
        UserDomain userDomain = userService.findByUserid((Integer) req.getCurrentUserId());
        if (userDomain.getIsadmin() > 0 || userDomain.getIsfinansys() > 0) {
            req.setCurrentUserId(null);
        }
        if (null != req.getCostForm() && 3 == req.getCostForm()) {
            req.setIsLend(1);
        }
        if (null != req.getCostForm() && 4 == req.getCostForm()) {
            req.setCostForm(3);
            req.setIsLend(2);
        }
        Page<CostDomain> page = costDao.queryPage(new Page<>(req.getPageNum(), req.getPageSize()), req);
        this.setPrimaryDepartment(page.getRecords());
        return page;
    }

    @Override
    public Page<CostDomain> queryPageFor4k(Page page,String sourceFrom){
        Page<CostDomain> data = costDao.queryPageFor4k(page,sourceFrom);
        List<CostDetailDomain>  costDetailList = costDetailDao.selectList(new LambdaQueryWrapper<CostDetailDomain>()
                .in(CostDetailDomain::getCostNo,data.getRecords().stream().map(x -> x.getCostNo()).collect(Collectors.toList())));
        Map<String,List<CostDetailDomain>> listMap = costDetailList.stream().collect(Collectors.groupingBy(x -> x.getCostNo()));
        data.getRecords().forEach(x -> x.setCostDetailDomainList(listMap.get(x.getCostNo())));
        return data;
    }

    @Resource
    CostCashiercallbackService costCashiercallbackService;

    void cashierCallbackReject(CostCashiercallbackDomain costCashiercallbackDomain) {
        // 保存驳回信息
        costCashiercallbackService.saveCostCashiercallbackResponse(costCashiercallbackDomain);
        // 费用单状态改为审核驳回，添加驳回理由
        // 修复驳回后提交出现费用单已存在的问题
        // 将后缀添加到  detail_key 字段
        CostDomain cost = this.getCostByCostNo(costCashiercallbackDomain.getCostNo());
        String oldDetailKey = cost.getDetailKey();

        if (null != oldDetailKey && oldDetailKey.contains("-")) {
            String[] split = oldDetailKey.split("-");
            if (split.length > 1) {
                int i = Integer.parseInt(split[1]) + 1;
                cost.setDetailKey(split[0] + "-" + i);
            }
        } else {
            cost.setDetailKey(cost.getCostNo() + "-" + 1);
        }
        cost.setRejectReason(costCashiercallbackDomain.getPaynote());
        cost.setCostStatus(3);
        cost.setRejectType(2);
        this.updateById(cost);
        log.info("出纳驳回，费用单状态更改成功" + costCashiercallbackDomain);

        costLogService.save(cost.getCostNo(), costCashiercallbackDomain.getPayuserid(), "被出纳驳回：" + costCashiercallbackDomain.getPaynote());
    }

    void cashierCallbackPass(CostCashiercallbackDomain costCashiercallbackDomain) {

        CostDomain costDomain = this.getCostByCostNo(costCashiercallbackDomain.getCostNo());

        // 获取xx货币-->CNY的汇率
        if (com.bailuntec.common.StringUtils.isNotEmpty(costCashiercallbackDomain.getCashierunitcode())) {
            BigDecimal toRmbRate = CurUtils.getCur(costCashiercallbackDomain.getCashierunitcode().toUpperCase(), "CNY");
            costCashiercallbackDomain.setToRmbRate(toRmbRate);
            costDomain.setToRmbRate(toRmbRate);
        }

        //  保存出纳付款记录
        Integer integer = costCashiercallbackService.saveCostCashiercallbackResponse(costCashiercallbackDomain);
        log.warn("保存出纳付款信息成功：" + integer + "   " + costCashiercallbackDomain);

        //  付款成功，更改费用单信息，否则返回失败
        costDomain.setCostStatus(4);

        if (null != costDomain.getIsLend()) {
            if (costDomain.getIsLend() == 1 && BigDecimal.ZERO.compareTo(costDomain.getHadPay()) >= 0) {
                costDomain.setLendStatus(1);
            }
        }
        costDomain.setAmountRmb(costCashiercallbackDomain.getCashierpaymoneyrmb());
        costDomain.setPayUserId(costCashiercallbackDomain.getPayuserid());
        costDomain.setPayTime(new Date());
        costDomain.setActualTime(costCashiercallbackDomain.getActualTime());

        this.updateCost(costDomain);
        costLogService.save(costCashiercallbackDomain.getCostNo(), costCashiercallbackDomain.getPayuserid(), "出纳收/付款成功：" + costCashiercallbackDomain.getPaynote());
    }

}
