package com.blt.other.module.cost.service.impl.cost;

import com.blt.other.module.cost.model.CostDomain;
import com.blt.other.module.cost.service.CostService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.stereotype.Component;


/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/10/29 3:03 下午
 */
@EnableAsync
@Component
@Slf4j
public class CostSubscribe {


    @Async
    public void subscribe(CostDomain costDomain) {

        CostService costService = CostServiceFactory.getCostService(costDomain);
        switch (costDomain.getCostStatus()) {
            //如果是待部门审核 就提交部门审核
            case CostDomain.STATUS_DEPARTMENT_CHECK:
                costService.departmentCheck(costDomain.getCostNo(), -1);
                break;
            //如果是待财务审核 就提交部门审核
            case CostDomain.STATUS_FINANCIAL_CHECK:
                costService.financialCheck(costDomain.getCostNo(), -1);
                break;
            //如果是待最终审核 就提交部门审核
            case CostDomain.STATUS_FINAL_CHECK:
                costService.finalCheck(costDomain.getCostNo(), -1);
                break;
            default:
                log.error("invalid cost status");
        }
    }
}
