package com.blt.other.module.cost.service.impl;

import com.blt.other.common.util.CurUtils;
import com.blt.other.module.cost.dao.CostDao;
import com.blt.other.module.cost.dao.CostDetailDao;
import com.blt.other.module.cost.model.CostDetailDomain;
import com.blt.other.module.cost.model.CostDomain;
import com.blt.other.module.cost.service.CostDetailService;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;

@Service
public class CostDetailServiceImpl implements CostDetailService {

    @Resource
    private CostDetailDao costDetailDao;
    @Resource
    CostDao costDao;

    @Override
    public List<CostDetailDomain> getCostDetailListByCostNo(String costNo) {
        return costDetailDao.selectListByCostNo(costNo);
    }

    @Override
    public CostDetailDomain getCostDetailByDetailNo(String detailNo) {
        return costDetailDao.selectByDetailNo(detailNo);
    }

    @Override
    public void deleteFilePath(String detailNo) {
        costDetailDao.deletedFilePath(detailNo);
    }


    @Transactional
    @Override
    public Integer update(CostDetailDomain domain) {
        //更新费用单
        return costDetailDao.update(domain);
    }
}
