package com.blt.other.module.purchasing.controller;

import com.blt.other.common.util.AxiosUtil;
import com.blt.other.database.model.BuyPlanDetailDomain;
import com.blt.other.module.purchasing.dto.BuyPlanDto;
import com.blt.other.module.purchasing.service.BuyPlanDetailService;
import com.blt.other.module.purchasing.service.BuyPlanService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.*;

/**
 * 采购计划 API 控制器
 */
@RestController
@RequestMapping("/purchasing/plan")
public class PurchasingPlanController {

    @Autowired
    private BuyPlanService buyPlanService;

    @Autowired
    private BuyPlanDetailService buyPlanDetailService;

    /**
     * 分页获取所有采购计划单
     *
     * @param page
     * @param response
     * @param request
     * @return
     */
    @GetMapping("/getAllPurchasingPlan/{page}")
    public Map<String, Object> getAllPurchasinPlan(@PathVariable("page") Integer page, HttpServletResponse response, HttpServletRequest request) {
        String origin = request.getHeader("Origin");
        response.setHeader("Access-Control-Allow-Origin", origin);
        response.setHeader("Access-Control-Allow-Credentials", "true");

        // 获取前端设置的每页显示条数
        String pageSize = request.getParameter("pageSize");

        Map<String, Object> allBuyPlanList = buyPlanService.getAllBuyPlanList(Integer.parseInt(pageSize), page);
        return allBuyPlanList;
    }

    /**
     * 通过采购计划单号获取计划单
     *
     * @return
     */
    @GetMapping("getBuyPlanByNo")
    public BuyPlanDto getBuyPlanByNo(HttpServletResponse response, HttpServletRequest request) {
        AxiosUtil.setCors(response, request);

        BuyPlanDto buyPlanByNo = buyPlanService.getBuyPlanByNo(request.getParameter("no"));
        return buyPlanByNo;
    }

    /**
     * 通过采购计划单号获取计划单详情
     *
     * @return
     */
    @GetMapping("getBuyPlanDetailByNo")
    public List<BuyPlanDetailDomain> getBuyPlanDetailByNo(HttpServletResponse response, HttpServletRequest request) {
        AxiosUtil.setCors(response, request);

        List<BuyPlanDetailDomain> no = buyPlanDetailService.getBuyPlanDetailByno(request.getParameter("no"));
        return no;
    }

    /**
     * 批量审核通过
     *
     * @param response
     * @param request
     * @return
     */
    @PostMapping("/batchAudit")
    public Map<String, Object> batchAudit(HttpServletResponse response, HttpServletRequest request) {
        AxiosUtil.setCors(response, request);
        Map<String, Object> result = new HashMap<>();

        Map<String, String[]> parameterMap = request.getParameterMap();
        List<String> planList = new ArrayList<>();

        Set<String> keys = parameterMap.keySet();
        String audituseridStr = null;
        String auditusername = null;
        for (String key : keys) {
            String[] valueArray = parameterMap.get(key);
            for (String value : valueArray) {
                if ("audituserid".equals(key)) {
                    audituseridStr = value;
                } else if ("auditusername".equals(key)) {
                    auditusername = value;
                } else {
                    // 获取批量选择的采购计划信息
                    BuyPlanDto buyPlanByNo = buyPlanService.getBuyPlanByNo(value);
                    // 判断采购计划是否是待主管审核状态
                    if (buyPlanByNo.getStatus() != 1) {
                        result.put("success", false);
                        result.put("msg", value + " 状态为：" + buyPlanByNo.getStatusdto());
                        return result;
                    }
                    planList.add(value);
                }
            }
        }
        Integer audituserid = null;
        if (null != audituseridStr) {
            audituserid = Integer.parseInt(audituseridStr);
        }
        Integer integer = buyPlanService.batchAuditUpdate(planList, audituserid, auditusername);
        if (null != integer && integer >= 1) {
            for (String no : planList) {
                buyPlanDetailService.saveNewBuyToBuy(no);
            }
            result.put("num", integer);
            result.put("success", true);
            result.put("msg", integer + " 条审核通过");
        } else {
            result.put("success", true);
            result.put("msg", "");
        }
        return result;
    }
}
