package com.blt.other.other_commons.utils;

public class PathUtil {
    /**
     * 需要获取操作系统的文件分隔符 separator
     */
    private static String separator = System.getProperty("file.separator");


    /**
     * 获取项目图片根路径
     * @return basePath
     */
    public static String getBasePath() {
        /**
         * 获取操作系统的类型
         */
        String os = System.getProperty("os.name");
        String basePath = "";
        if (os.toLowerCase().startsWith("win")) {
//            basePath = "E:/library/Documents/file/bailuntec/other/";
            basePath = "C:/FeeSystemFiles/other/";
        }else if (os.toLowerCase().startsWith("mac")){
            basePath = "/Users/bailuntec/other/";
        }else {
            basePath = "/home/bailuntec/other/";
        }
        return basePath.replace("/",separator);
    }

    /**
     * 根据业务需求返回相对应的子路径
     * @return 系统格式化后的文件路径
     */
    public static String getPath(String path){
        String filePath = String.format(path);
        return filePath.replace("/",separator);
    }

    /**
     * 获取文件名
     * @param filePath
     * @return
     */
    public static String getFileName(String filePath) {
        String fileName = null;
        if (null != filePath) {
            String[] split = filePath.split("&");
            if (null != split && split.length >= 1) {
                fileName = split[split.length - 1];
            }
        }

        return fileName;
    }
}
