package com.blt.other.other_commons.service.impl;

import com.blt.other.other_commons.dao.IndexDao;
import com.blt.other.other_commons.service.IndexService;
import com.blt.other.other_cost.dto.CostDto;
import com.blt.other.other_cost.dto.CostPlanDto;
import com.blt.other.other_cost.service.CostListSearchService;
import com.blt.other.other_cost.service.CostPlanService;
import com.blt.other.other_database.model.BuyPlanDomain;
import com.blt.other.other_database.model.CostDomain;
import com.blt.other.other_database.model.CostPlanDomain;
import com.blt.other.other_purchasing.dto.BuyPlanDto;
import com.blt.other.other_purchasing.service.BuyPlanService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class IndexServiceImpl implements IndexService {

    @Autowired
    private IndexDao indexDao;
    @Autowired
    private BuyPlanService buyPlanService;
    @Autowired
    private CostPlanService costPlanService;
    @Autowired
    private CostListSearchService costListSearchService;

    @Override
    public List<BuyPlanDto> getBuyPlanList(Integer userid) {
        List<BuyPlanDomain> buyPlanDomains = indexDao.selectBuyPlanList(userid);
        List<BuyPlanDto> dtoList = buyPlanService.getDtoList(buyPlanDomains);
        return dtoList;
    }

    @Override
    public List<CostPlanDto> getCostPlanList(Integer userid) {
        List<CostPlanDomain> costPlanDomains = indexDao.selectCostPlanList(userid);
        List<CostPlanDto> costPlanDtos = costPlanService.domainListToDtoList(costPlanDomains);
        return costPlanDtos;
    }

    @Override
    public List<CostDto> getCostList(Integer userid) {
        List<CostDomain> costDomains = indexDao.selectCostList(userid);
        List<CostDto> costDtos = costListSearchService.domainListToDto(costDomains);
        return costDtos;
    }

}
