package com.blt.other.other_cost.config;


import com.blt.other.other_cost.job.CostStatusSyncJob;
import org.quartz.*;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class CostStatusSyncConfiguration {


    // 扫描主体列表时间间隔：（秒）
    private static final int TIME = 86400;

    // JobDetail 定义要执行的 job
    @Bean
    public JobDetail costCompanySyncJobJobDetail(){
        return JobBuilder.newJob(CostStatusSyncJob.class)
                .withIdentity("costStatusSyncJob")
                .storeDurably().build();
    }

    // 触发 Bean 的 Trigger
    @Bean
    public Trigger costCompanySyncJobTrigger(){
        SimpleScheduleBuilder simpleScheduleBuilder = SimpleScheduleBuilder.simpleSchedule()
                .withIntervalInSeconds(TIME).repeatForever();
        return TriggerBuilder.newTrigger().forJob(costCompanySyncJobJobDetail())
                .withIdentity("costStatusSuncTrigger")
                .withSchedule(simpleScheduleBuilder).build();
    }
}
