package com.bailuntec.cost.api;


import com.bailuntec.cost.api.dto.*;
import com.bailuntec.cost.api.request.ManageCostListReq;
import com.bailuntec.cost.api.response.CostResult;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.io.IOException;
import java.util.List;

@FeignClient(name = "bailuntec-cost-api", url = "http://api.fee.bailuntec.com/purchase/other")
public interface CostApi {


    @ApiOperation("接受工资单，自动生成付款费用单到财务审核")
    @PostMapping("/cost/api/pushWageCost")
    CostResult<Void> pushWageCost(@RequestBody WageCostDto wageCostDto) throws IOException;

    @ApiOperation("接收物流单，自动生成付款费用单到财务审核")
    @PostMapping("/cost/api/pushLogisticsCost")
    CostResult<Void> pushLogisticsCost(@RequestBody LogisticsCostDto logisticsCostDto) throws Exception;

    @ApiOperation("吴通接收物流单，自动生成收款费用单到财务审核")
    @PostMapping("/cost/api/pushLogisticsReceipt")
    CostResult<Void> pushLogisticsReceipt(@RequestBody LogisticsCostDto logisticsCostDto) throws Exception;

    @ApiOperation("接收收付款单")
    @PostMapping("/pushCost")
    CostResult<Void> pushCost(@RequestBody CostInputDto input) throws Exception;

    @ApiOperation("获取所有费用单和采购单")
    @PostMapping("/cost/api/manageCostList")
    CostResult<List<ManageCostDto>> manageCostList(@RequestBody ManageCostListReq req);

    @GetMapping("/cost/api/noPayCost")
    @ApiOperation("查询原来传输到数据中心时为待支付状态 变成 已支付状态后的费用单")
    CostResult<List<CostDto>> getNoPayCost(@RequestParam(name = "costNoList") List<String> costNoList);



    @ApiOperation("吴通新增 根据费用单号获取费用单大类")
    @GetMapping("/cost/api/type/{costNo}")
    CostResult<String> getTypeName(@PathVariable("costNo") String costNo);

    /**
     * 获取费用系统列表
     *
     * @param startDate 开始时间
     * @param endDate   结束时间
     * @param pageNum   分页
     * @param pageSize  分页
     * @return res
     */
    @ApiOperation("获取费用系统列表")
    @GetMapping({"/cost/api/getCostList"})
    CostResult<List<CostDto>> getCostList(@RequestParam(name = "startDate") String startDate,
                                          @RequestParam(name = "endDate") String endDate,
                                          @RequestParam(name = "pageNum") Integer pageNum,
                                          @RequestParam(name = "pageSize") Integer pageSize);
}
