package com.blt.other.module.cost.service.impl.costcheck;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.blt.other.database.model.CostCompanyDomain;
import com.blt.other.module.cost.dao.CostCompanyDao;
import com.blt.other.module.cost.dao.CostDao;
import com.blt.other.module.cost.model.CostDomain;
import com.blt.other.module.cost.service.ICostCurrentReviewerService;
import com.blt.other.module.sys.dao.CostReviewerMapper;
import com.blt.other.module.sys.model.CostReviewer;
import com.google.common.collect.Lists;
import org.junit.jupiter.api.Test;
import org.junit.runner.RunWith;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.annotation.Rollback;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2021/1/8 6:02 下午
 */
@Transactional
@RunWith(SpringJUnit4ClassRunner.class)
@SpringBootTest
@ActiveProfiles("prod")
class FinancialCheckStateTest {

    @Resource
    CostDao costDao;
    @Resource
    CostCompanyDao costCompanyDao;
    @Resource
    CostReviewerMapper costReviewerMapper;
    @Resource
    ICostCurrentReviewerService costCurrentReviewerService;
    @Resource
    FinancialCheckState financialCheckState;

    @Test
    @Rollback(value = false)
    public void reSet() {
        List<String> costs = Lists.newArrayList("F031366", "F031367", "F031370");
        costs.forEach(this::reSet);
    }

    //F031366
    //F031367
    //F031370
    private void reSet(String costNo) {
        CostDomain costDomain = costDao.selectByCostNo(costNo);
        CostCompanyDomain costCompanyDomain = costCompanyDao.selectByNo(costDomain.getCompanyNo());


        List<CostReviewer> costReviewerList = costReviewerMapper.selectList(new LambdaQueryWrapper<CostReviewer>()
                .eq(CostReviewer::getReferId, costCompanyDomain.getId())
                .eq(CostReviewer::getType, CostReviewer.financialReviewer));

        costCurrentReviewerService.updateByCostNoAndReviewer(costDomain.getCostNo(), costReviewerList);
    }

    @Rollback(value = false)
    @Test
    void updateCurrentReviewer() {

        CostDomain costDomain = costDao.selectByCostNo("F031533");
        CostContext costContext = new CostContext("F031533", costDomain.getCreateUserid());
        costContext.setCostState(financialCheckState);
        financialCheckState.updateCurrentReviewer();
    }
}
