package com.blt.other.module.sys.service.impl;

import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.fastjson.JSON;
import com.bailuntec.common.ListUtil;
import com.bailuntec.common.SpringContextUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.blt.other.database.model.CostCompanyDomain;
import com.blt.other.module.auth.dao.OaUserMapper;
import com.blt.other.module.auth.model.OaUser;
import com.blt.other.module.cost.dao.CostCompanyDao;
import com.blt.other.module.sys.dao.CostReviewerMapper;
import com.blt.other.module.sys.dto.request.CostReviewerImportItem;
import com.blt.other.module.sys.model.CostReviewer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2021/1/22 2:54 下午
 */
public class CostReviewerImportItemListener extends AnalysisEventListener<CostReviewerImportItem> {

    private static final Logger LOGGER = LoggerFactory.getLogger(CostReviewerImportItemListener.class);


    private static final int BATCH_COUNT = 1000;
    List<CostReviewerImportItem> list = new ArrayList<>();

    @Override
    public void invoke(CostReviewerImportItem data, AnalysisContext context) {
        LOGGER.info("解析到一条数据:{}", JSON.toJSONString(data));
        list.add(data);
        if (list.size() >= BATCH_COUNT) {
            syncData();
            list.clear();
        }
    }

    @Override
    public void doAfterAllAnalysed(AnalysisContext context) {
        syncData();
        LOGGER.info("所有数据解析完成！");
    }

    private void syncData() {
        LOGGER.info("{}条数据，开始存储数据库！", list.size());

        CostCompanyDao costCompanyDao = SpringContextUtil.getBean(CostCompanyDao.class);
        OaUserMapper oaUserMapper = SpringContextUtil.getBean(OaUserMapper.class);
        CostReviewerMapper costReviewerMapper = SpringContextUtil.getBean(CostReviewerMapper.class);

        list.forEach(item -> {
            CostCompanyDomain costCompanyDomain = costCompanyDao.selectByName(item.getCompanyName());
            if (costCompanyDomain != null) {

                List<OaUser> financialReviewerUser = oaUserMapper.selectByUserNames(item.getFinancialReviewerUser());
                if (ListUtil.isNotEmpty(financialReviewerUser)) {
                    costReviewerMapper.delete(new LambdaQueryWrapper<CostReviewer>()
                            .eq(CostReviewer::getType, CostReviewer.financialReviewer));
                    financialReviewerUser
                            .forEach(oaUser -> {
                                CostReviewer costReviewer = new CostReviewer();
                                costReviewer.setReviewerUserId(oaUser.getOaUserId());
                                costReviewer.setReviewerUserName(oaUser.getUserName());
                                costReviewer.setReferId(costCompanyDomain.getId());
                                costReviewer.setType(CostReviewer.financialReviewer);
                                costReviewerMapper.insert(costReviewer);
                            });
                }

                List<OaUser> finalReviewerUser = oaUserMapper.selectByUserNames(item.getFinalReviewerUser());
                if (ListUtil.isNotEmpty(finalReviewerUser)) {
                    costReviewerMapper.delete(new LambdaQueryWrapper<CostReviewer>()
                            .eq(CostReviewer::getType, CostReviewer.finalReviewer));
                    financialReviewerUser
                            .forEach(oaUser -> {
                                CostReviewer costReviewer = new CostReviewer();
                                costReviewer.setReviewerUserId(oaUser.getOaUserId());
                                costReviewer.setReviewerUserName(oaUser.getUserName());
                                costReviewer.setReferId(costCompanyDomain.getId());
                                costReviewer.setType(CostReviewer.finalReviewer);
                                costReviewerMapper.insert(costReviewer);
                            });
                }

                List<OaUser> hrReviewerUser = oaUserMapper.selectByUserNames(item.getHrReviewerUser());
                if (ListUtil.isNotEmpty(hrReviewerUser)) {
                    costReviewerMapper.delete(new LambdaQueryWrapper<CostReviewer>()
                            .eq(CostReviewer::getType, CostReviewer.hrReviewer));
                    financialReviewerUser
                            .forEach(oaUser -> {
                                CostReviewer costReviewer = new CostReviewer();
                                costReviewer.setReviewerUserId(oaUser.getOaUserId());
                                costReviewer.setReviewerUserName(oaUser.getUserName());
                                costReviewer.setReferId(costCompanyDomain.getId());
                                costReviewer.setType(CostReviewer.hrReviewer);
                                costReviewerMapper.insert(costReviewer);
                            });
                }
            }
        });
        LOGGER.info("存储数据库成功！");
    }
}
