package com.blt.other.module.netsuite.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bailuntec.common.ListUtil;
import com.baomidou.mybatisplus.extension.service.IService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.blt.other.common.util.OAuth1Util;
import com.blt.other.module.netsuite.dao.NetsuiteLogDao;
import com.blt.other.module.netsuite.dto.NetsuiteDataDto;
import com.blt.other.module.netsuite.dto.NetsuiteKey;
import com.blt.other.module.netsuite.dto.NetsuiteLogDto;
import com.blt.other.module.netsuite.model.NetsuiteLogDomain;
import com.blt.other.module.netsuite.service.NetsuiteLogService;
import com.qiniu.util.Json;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.http.HttpResponse;
import org.jose4j.json.JsonUtil;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @Author: li.yanlin
 * @Description：
 * @Date: Created in  2021-04-28
 * @Modified by:
 */
@Service
@Slf4j
public class NetsuiteLogServiceImpl extends ServiceImpl<NetsuiteLogDao,NetsuiteLogDomain> implements NetsuiteLogService {

    @Resource
    private NetsuiteLogDao netsuiteLogDao;

    @Resource
    private NetsuiteKey netsuiteKey;

    @Override
    public void publishToNetsuite(int top) {
        if(!netsuiteKey.getDoWork()){
            return;
        }
        //78:费用单
        Map<String,Object> resultMap = new HashMap<>();
        List<NetsuiteLogDto> list = netsuiteLogDao.selectNonPublishTop(NetsuiteLogDomain.SCRIPT_FEE,top);
        if(ListUtil.isEmpty(list)){
            return;
        }
        List<NetsuiteDataDto> netsuiteDataDtoList = list.stream()
                .map(x -> JSON.parseObject(x.getJsonStr(), NetsuiteDataDto.class))
                .collect(Collectors.toList());
        List<String> costNos = list.stream().map(x -> x.getCostNo()).collect(Collectors.toList());
        resultMap.put("costNos",costNos);
        OAuth1Util.setupContext(netsuiteKey.getConsumerKey(),
                netsuiteKey.getConsumerSecret(),
                netsuiteKey.getToken(),
                netsuiteKey.getTokenSecret(),
                netsuiteKey.getRealm());
        try {
            String response = OAuth1Util.executePost(String.format(netsuiteKey.getBaseUrl(),NetsuiteLogDomain.SCRIPT_FEE),
                    null,
                    JSON.toJSONString(netsuiteDataDtoList));
            JSONObject jobj = JSON.parseObject(response);
            if(!BooleanUtils.toBoolean(jobj.get("status").toString())){
                String errorMsg = String.format("同步到NetSuite中心异常,\nNetSuite返回内容：%s\n任务ID：78\n请求参数:%s",
                        response,
                        JSON.toJSONString(netsuiteDataDtoList));
                resultMap.put("status", NetsuiteLogDomain.FAILURE);
                resultMap.put("error",errorMsg);
                log.info(errorMsg);
            }
            else{
                resultMap.put("status", NetsuiteLogDomain.PUBLISHED);
            }
        } catch (Exception e) {
            resultMap.put("status", NetsuiteLogDomain.FAILURE);
            resultMap.put("error",e.getMessage());
            log.info(e.toString());
        }
        netsuiteLogDao.updatePublishStatus(resultMap);
    }
}
