package com.blt.other.module.entrepot.service.impl;

import com.blt.other.database.mapper.StatusMapper;
import com.bailuntec.cost.api.domain.BuyDomain;
import com.blt.other.database.model.InventoryDomain;
import com.blt.other.database.model.InventoryLogDomain;
import com.blt.other.module.entrepot.dao.InventoryDao;
import com.blt.other.module.entrepot.dao.InventoryLogDao;
import com.blt.other.module.entrepot.dto.InventoryLogDto;
import com.blt.other.module.entrepot.service.InventoryLogService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.text.SimpleDateFormat;
import java.util.*;

@Service
public class InventoryLogServiceImpl implements InventoryLogService {

    @Autowired
    private InventoryLogDao inventoryLogDao;

    @Autowired
    private InventoryDao inventoryDao;

    @Autowired
    private StatusMapper statusMapper;

    /**
     * 采购入库保存库存变更日志
     * @param
     * @return
     */
    @Override
    public InventoryLogDto saveInventoryLog(BuyDomain buyDomain,Integer numBefore,Integer numLater) {
        InventoryLogDomain inventoryLogDomain = new InventoryLogDomain();
        inventoryLogDomain.setInventoryLogNo(createInventoryLogNo());
        inventoryLogDomain.setCreateTime(new Date());
        inventoryLogDomain.setCreateUserId(buyDomain.getCreateuserid());
        inventoryLogDomain.setCreateUserName(buyDomain.getCreateusername());
        inventoryLogDomain.setInventoryLogType(0);
        inventoryLogDomain.setNote("采购入库");
        inventoryLogDomain.setNumBefore(numBefore);
        inventoryLogDomain.setNumLater(numLater);
        InventoryDomain inventoryDomain = inventoryDao.selectByWarehouseidAndSkucode(buyDomain.getWarehouseid(),buyDomain.getSkucode());
        inventoryLogDomain.setInventoryNo(inventoryDomain.getInventoryNo());
        Integer insert = inventoryLogDao.insert(inventoryLogDomain);
        if (null != insert && insert >= 1){
            return domainToDto(inventoryLogDomain);
        }
        return null;
    }

    @Override
    public InventoryLogDto save(InventoryLogDomain inventoryLogDomain) {
        inventoryLogDomain.setCreateTime(new Date());
        inventoryLogDomain.setInventoryLogNo(createInventoryLogNo());
        Integer insert = inventoryLogDao.insert(inventoryLogDomain);
        return domainToDto(inventoryLogDomain);
    }

    /**
     * 根据库存编号获取库存日志列表
     * @param inventoryNo
     * @return
     */
    @Override
    public Map<String,Object> getInventoryLogsByInventoryNo(String inventoryNo,Integer pageNum,Integer pageSize) {
        PageHelper.startPage(pageNum,pageSize);
        List<InventoryLogDomain> inventoryLogDomains = inventoryLogDao.selectByInventoryNo(inventoryNo);
        List<InventoryLogDto> inventoryLogDtos = new ArrayList<>();
        if (null != inventoryLogDomains && inventoryLogDomains.size() >= 1){
            for (InventoryLogDomain inventoryLogDomain : inventoryLogDomains){
                inventoryLogDtos.add(domainToDto(inventoryLogDomain));
            }
        }
        PageInfo<InventoryLogDomain> pageInfo = new PageInfo<>(inventoryLogDomains);
        Map<String,Object> result = new HashMap<>();
        result.put("pageInfo",pageInfo);
        result.put("inventoryLogs",inventoryLogDtos);
        return result;
    }

    /**
     * 类型转换
     * @param inventoryLogDomain
     * @return
     */
    private InventoryLogDto domainToDto(InventoryLogDomain inventoryLogDomain){
        InventoryLogDto inventoryLogDto = new InventoryLogDto();
        BeanUtils.copyProperties(inventoryLogDomain,inventoryLogDto);
        String inventory_log_type = statusMapper.getStatusValue("inventory_log_type", inventoryLogDomain.getInventoryLogType());
        inventoryLogDto.setInventoryLogTypeDto(inventory_log_type);
        return inventoryLogDto;
    }

    /**
     * 生成唯一编号
     * @return
     */
    private String createInventoryLogNo(){
        String inventoryLogNo = null;
        Random random = new Random();
        SimpleDateFormat sdf = new SimpleDateFormat("yyMMddHHmmss");
        inventoryLogNo = "ILN"+sdf.format(new Date())+random.nextInt(9);
        InventoryLogDomain inventoryLogDomain = inventoryLogDao.selectByNo(inventoryLogNo);
        while (null != inventoryLogDomain && null != inventoryLogDomain.getId()){
            inventoryLogNo = "ILN"+sdf.format(new Date())+random.nextInt(9);
            inventoryLogDomain = inventoryLogDao.selectByNo(inventoryLogNo);
        }
        return inventoryLogNo;
    }
}
