package com.blt.other.module.cost.controller;

import com.blt.other.common.util.AxiosUtil;
import com.blt.other.database.model.UserDomain;
import com.blt.other.module.cost.dto.request.ResetReq;
import com.blt.other.module.cost.dto.response.ResetResp;
import com.blt.other.module.cost.model.CostDetailDomain;
import com.blt.other.module.cost.service.CostDetailService;
import com.blt.other.module.cost.service.CostLogService;
import com.blt.other.module.sys.service.UserService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@RestController
@Api(tags = "付款单详情接口")
@RequestMapping("/cost/detail")
public class CostDetailController {

    @Autowired
    private CostDetailService costDetailService;
    @Autowired
    private CostLogService costLogService;
    @Autowired
    private UserService userService;

    @PostMapping("/getCostDetailList")
    public Map<String, Object> getCostDetailList(HttpServletResponse response, HttpServletRequest request, Integer userId) {
        AxiosUtil.setCors(response, request);

        String costNo = request.getParameter("costNo");
        List<CostDetailDomain> costDetailListByCostNo = costDetailService.getCostDetailListByCostNo(costNo);
        Map<String, Object> result = new HashMap<>();

        UserDomain user = userService.findByUserid(userId);

        for (CostDetailDomain detail : costDetailListByCostNo) {
            if (detail != null && costDetailListByCostNo.size() > 0) {
                //类型标题  大类
                String typeName = detail.getTypeName();
                //种类标题 小类
                String accountingSubjectName = detail.getAccountingSubjectName();
                if ((typeName.contains("工资") ||
                        accountingSubjectName.contains("工资")) &&
                        !(user.getUseraccount().equals("程文爱")
                                || user.getUseraccount().equals("苏佩虹")
                                || user.getUseraccount().equals("张晓雯")
                                || user.getUseraccount().equals("王埕")
                                || user.getUseraccount().equals("赵伟铭")
                                || user.getUseraccount().equals("李静雯")
                                || user.getUseraccount().equals("董梓玲")
                                || user.getUseraccount().equals("简金源")
                                || user.getUseraccount().equals("廖文珊")
                                || user.getUseraccount().equals("李燕霞")
                                || user.getUseraccount().equals("黄晔")
                                || user.getUseraccount().equals("唐衍芬")
                                || user.getUseraccount().equals("罗贞")
                                || user.getUseraccount().equals("陈文静")
                                || user.getUseraccount().equals("林冬菊")
                                || user.getUseraccount().equals("梁献云")
                                || user.getUseraccount().equals("姚晓婷")
                                || user.getUseraccount().equals("刘春丽")
                                || user.getUseraccount().equals("魏秋裕")
                                || user.getUseraccount().equals("关秀利")
                                || detail.getCreateUsername().equals(user.getUseraccount()))) {
                    detail.setFilePath("");
                }
                if (detail.getFilePath() == null) {
                    detail.setFilePath("");
                }
            }
        }

        result.put("costDetails", costDetailListByCostNo);
        return result;
    }

    @GetMapping("download")
    public ResponseEntity<InputStreamResource> download(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String detailNo = request.getParameter("detailNo");
        CostDetailDomain detail = costDetailService.getCostDetailByDetailNo(detailNo);
        String filePath;
        String fileName = null;
        if (null != detail) {
            filePath = detail.getFilePath();
            if (null != filePath) {
                String[] split = filePath.split("&");
                if (split.length >= 1) {
                    fileName = split[split.length - 1];
                }
            }
        } else {
            return null;
        }

        FileSystemResource file = new FileSystemResource(filePath);
        HttpHeaders headers = new HttpHeaders();
        headers.add("Cache-Control", "no-cache, no-store, must-revalidate");
        // new String(fileName.getBytes("UTF-8"),"iso-8859-1") 解决文件下载的时候文件名乱码的问题
        headers.add("Content-Disposition", String.format("attachment; filename=\"%s\"", new String(fileName.getBytes("UTF-8"), "iso-8859-1")));
        headers.add("Pragma", "no-cache");
        headers.add("Expires", "0");

        return ResponseEntity
                .ok()
                .headers(headers)
                .contentLength(file.contentLength())
                .contentType(MediaType.parseMediaType("application/octet-stream"))
                .body(new InputStreamResource(file.getInputStream()));
    }

    @GetMapping("/getDetailByNo")
    public Map<String, Object> getDetailByNo(HttpServletResponse response, HttpServletRequest request) {
        AxiosUtil.setCors(response, request);
        String detailNo = request.getParameter("detailNo");
        CostDetailDomain costDetailByDetailNo = costDetailService.getCostDetailByDetailNo(detailNo);
        Map<String, Object> result = new HashMap<>();
        result.put("detail", costDetailByDetailNo);
        if (null != costDetailByDetailNo.getFilePath() && !costDetailByDetailNo.getFilePath().isEmpty()) {
            String filePath = costDetailByDetailNo.getFilePath();
            int i = filePath.lastIndexOf("&");
            String substring = filePath.substring(i + 1, filePath.length());
            result.put("fileName", substring);
        }
        return result;
    }

    @ApiOperation("更新费用详情")
    @PostMapping({"/resetItem/noFile", "/resetItem/file"})
    public ResetResp reset(ResetReq req) {
        return costDetailService.reset(req);
    }


    @GetMapping("/getCostLogs")
    public Map<String, Object> getCostLogs(HttpServletResponse response, HttpServletRequest request) {
        AxiosUtil.setCors(response, request);
        String costNo = request.getParameter("costNo");
        List<String> costLogs = costLogService.getListLogs(costLogService.getListByCostNo(costNo));
        Map<String, Object> result = new HashMap<>();
        result.put("costLogs", costLogs);
        return result;
    }

}
