package com.blt.other.module.cost.dto.request;

import com.bailuntec.common.base.BaseRequest;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;
import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2021/1/16 9:44 上午
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class CostQueryPageReq extends BaseRequest {

    @ApiModelProperty("项目类型")
    private String projectTypes;

    @ApiModelProperty("主体编号")
    private String companyNo;

    @ApiModelProperty("1 付款费用 2 收款费用 3 借支/借还")
    private Integer costForm;

    @ApiModelProperty("创建人id")
    private Integer createUserid;

    @ApiModelProperty("费用单状态 0 待提交 1- 待财务审核 2待出纳付款 3被驳回 4已支付 5已作废  6-待部门审核 7-待财务审核 8-待最终审核人审核")
    private Integer costStatus;

    @ApiModelProperty("1 未还 2 部分还款  3 待补差额  4 结清")
    private Integer lendStatus;

    @ApiModelProperty("0 不抵扣个税  1 抵扣个税")
    private Integer isTax;

    @ApiModelProperty("1 借支 2 借还")
    private Integer isLend;

    @ApiModelProperty("费用单创建时间")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date beginTime;

    @ApiModelProperty("费用单创建时间")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date endTime;

    @ApiModelProperty("费用单支付时间")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date beginPayTime;

    @ApiModelProperty("费用单支付时间")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date endPayTime;

    @ApiModelProperty("关联费用单")
    private String linkCost;

    @ApiModelProperty("模糊搜索字段")
    private String key;

    private List<String> keys;

}
