package com.blt.other.module.entrepot.service;

import com.blt.other.module.database.model.BuyDomain;
import com.blt.other.module.database.model.InventoryDomain;

import java.util.Map;

public interface InventoryService {

    /**
     * 新增库存记录
     * @param buyDomain
     * @return
     */
    InventoryDomain saveInventory(BuyDomain buyDomain);


    /**
     * 根据 sku 编号获取库存信息
     * @param skucode
     * @return
     */
    InventoryDomain getBySkucode(String skucode);

    /**
     * 根据 warehouseid + sku 编号获取库存信息
     * @param skucode
     * @return
     */
    InventoryDomain getByWarehouseidAndSkucode(String warehouseid,String skucode);

    /**
     * 更改库存
     * @param inventoryDomain
     * @param inventoryNum
     * @return
     */
    InventoryDomain update(InventoryDomain inventoryDomain,Integer inventoryNum);

    /**
     * 分页获取库存列表
     * @return
     */
    Map<String,Object> getAllInventories(Integer pageNum,Integer pageSize);

    /**
     * 获取库存信息
     * @param inventoryNo
     * @return
     */
    InventoryDomain getByInventoryNo(String inventoryNo);
}
