package com.blt.other;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.fastjson.JSON;
import com.bailuntec.api.bailuntec.oa.OaApi;
import com.bailuntec.api.bailuntec.oa.response.OaDepartmentResp;
import com.bailuntec.api.bailuntec.oa.response.OaUserResp;
import com.bailuntec.common.JsonUtilByJackson;
import com.bailuntec.common.SpringContextUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.blt.other.common.interceptor.mail.MailService;
import com.blt.other.common.rabbitmq.service.receiver.DefaultRegisterQueueService;
import com.blt.other.common.rabbitmq.service.sender.DefaultSendService;
import com.blt.other.common.util.OAuth1Util;
import com.blt.other.database.model.CostCashiercallbackDomain;
import com.blt.other.database.model.CostCompanyDomain;
import com.blt.other.database.model.CostTypeDomain;
import com.blt.other.module.auth.dao.OaDepartmentMapper;
import com.blt.other.module.auth.dao.OaUserMapper;
import com.blt.other.module.auth.model.OaDepartment;
import com.blt.other.module.auth.model.OaUser;
import com.blt.other.module.auth.service.IOaDepartmentService;
import com.blt.other.module.auth.service.IOaUserService;
import com.blt.other.module.cost.dao.*;
import com.blt.other.module.cost.dto.response.CostTypeResult;
import com.blt.other.module.cost.model.AccountingSubject;
import com.blt.other.module.cost.model.CostCurrentReviewer;
import com.blt.other.module.cost.model.CostDetailDomain;
import com.blt.other.module.cost.model.CostDomain;
import com.blt.other.module.netsuite.dao.NetsuiteLogDao;
import com.blt.other.module.netsuite.dto.NetsuiCostinfoDto;
import com.blt.other.module.netsuite.dto.NetsuiteDataDto;
import com.blt.other.module.netsuite.model.NetsuiteLogDomain;
import com.blt.other.module.netsuite.service.NetsuiteLogService;
import com.blt.other.module.sys.dao.CostReviewerMapper;
import com.blt.other.module.sys.dao.DepartmentReviewerMapper;
import com.blt.other.module.sys.dto.request.DepartmentReviewerListReq;
import com.blt.other.module.sys.dto.response.DepartmentReviewerListItem;
import com.blt.other.module.sys.model.CostReviewer;
import com.blt.other.module.sys.model.DepartmentReviewer;
import com.blt.other.module.sys.service.IDepartmentReviewerService;
import lombok.Data;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;

import org.springframework.test.annotation.Rollback;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.transaction.annotation.Transactional;
import org.thymeleaf.util.StringUtils;

import javax.annotation.Resource;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Transactional
@RunWith(SpringRunner.class)
@SpringBootTest(classes = OtherApplication.class)
@ActiveProfiles("prod")
public class OtherApplicationTests {

    @Autowired
    private OaApi oaApi;
    @Autowired
    private IOaUserService oaUserService;
    @Autowired
    private IOaDepartmentService oaDepartmentService;
    @Resource
    OaDepartmentMapper oaDepartmentMapper;
    @Resource
    CostReviewerMapper costReviewerMapper;
    @Resource
    DepartmentReviewerMapper departmentReviewerMapper;
    @Resource
    NetsuiteLogDao netsuiteLogDao;
    @Resource
    CostDetailDao costDetailDao;
    @Resource
    NetsuiteLogService netsuiteLogService;

    @Rollback
    @Test
    public void syncDepartmentReviewer() {
        departmentReviewerMapper.delete(new LambdaQueryWrapper<>());

        List<CostReviewer> costReviewerList = costReviewerMapper.selectList(new LambdaQueryWrapper<CostReviewer>()
                .eq(CostReviewer::getType, 1));

        costReviewerList.stream().collect(Collectors.groupingBy(CostReviewer::getReferId))
                .forEach((departmentId, list) -> {

                    OaDepartment oaDepartment = oaDepartmentMapper.selectByDepartmentId(departmentId);
                    DepartmentReviewer departmentReviewer = new DepartmentReviewer();
                    departmentReviewer.setPrimaryDepartmentId(oaDepartment.getDepartmentId());
                    departmentReviewer.setAutoReviewAmount(oaDepartment.getDepartmentMinimumReviewAmount());
                    departmentReviewer.setPrimaryDepartmentName(oaDepartment.getName());

                    departmentReviewer.setSecondDepartmentId(0);
                    departmentReviewer.setSecondDepartmentName("全部");
                    departmentReviewer.setCreateTime(LocalDateTime.now());
                    departmentReviewer.setLastUpdateTime(LocalDateTime.now());

                    departmentReviewerMapper.insert(departmentReviewer);

                    list.forEach(costReviewer -> {
                        costReviewer.setReferId(departmentReviewer.getId());
                        costReviewer.setType(CostReviewer.departmentReviewer);
                        costReviewer.setId(null);
                        costReviewerMapper.insert(costReviewer);
                    });

                });
        costReviewerList.forEach(costReviewer -> {


        });
    }

    @Rollback(value = false)
    @Test
    public void syncOa() {
        List<OaUserResp> oaUserRespList = oaApi.getAllUser();
        List<OaDepartmentResp> oaDepartmentRespList = oaApi.getDeparmentList();

        List<OaUser> oaUserList = oaUserRespList.stream().map(oaUserResp -> {
            OaUser oaUser = new OaUser();
            oaUser.setCompanyId(oaUserResp.getCompanyId());
            oaUser.setDepartmentId(oaUserResp.getDepartmentId());
            oaUser.setOaUserId(oaUserResp.getId());
            oaUser.setUserAccount(oaUserResp.getUserAccount());
            oaUser.setUserCode(oaUserResp.getUserCode());
            oaUser.setUserName(oaUserResp.getUserName());
            return oaUser;
        })
                .collect(Collectors.toList());


        List<OaDepartment> oaDepartmentList = oaDepartmentRespList.stream().map(oaDepartmentResp -> {
            OaDepartment oaDepartment = new OaDepartment();
            oaDepartment.setCode(oaDepartmentResp.getCode());
            oaDepartment.setCompanyId(oaDepartmentResp.getCompanyId());
            oaDepartment.setManageUser1(oaDepartmentResp.getManageUser1());
            oaDepartment.setManageUser2(oaDepartmentResp.getManageUser2());
            oaDepartment.setName(oaDepartmentResp.getName());
            oaDepartment.setSort(oaDepartmentResp.getSort());
            oaDepartment.setParentId(oaDepartmentResp.getParentId());
            oaDepartment.setDepartmentId(oaDepartmentResp.getDepartmentId());
            oaDepartment.setFullName(oaDepartmentResp.getFullName());
            return oaDepartment;
        })
                .collect(Collectors.toList());

        Map<Integer, OaDepartment> oaDepartmentMap = oaDepartmentList.stream().collect(Collectors.toMap(
                OaDepartment::getDepartmentId, oaDepartment -> oaDepartment, (k1, k2) -> k1
        ));
        oaUserList.forEach(oaUser -> {
            oaUser.setPrimaryDepartmentId(this.getPrimaryDepartment(oaDepartmentMap, oaDepartmentMap.get(oaUser.getDepartmentId())).getDepartmentId());
            if (oaUserService.getOne(new LambdaQueryWrapper<OaUser>().eq(OaUser::getOaUserId, oaUser.getOaUserId())) == null) {
                oaUserService.save(oaUser);
            }
        });

        oaDepartmentList.forEach(oaDepartment -> {
            if (oaDepartmentMapper.selectByDepartmentId(oaDepartment.getDepartmentId()) == null) {
                oaDepartment.setUpdateUserId(0);
                oaDepartmentService.save(oaDepartment);
            } else {
                oaDepartmentService.update(oaDepartment, new LambdaQueryWrapper<OaDepartment>()
                        .eq(OaDepartment::getDepartmentId, oaDepartment.getDepartmentId()));
            }
        });

    }

    private OaDepartment getPrimaryDepartment(Map<Integer, OaDepartment> departmentMap, OaDepartment oaDepartment) {
        if (oaDepartment == null) {
            return new OaDepartment();
        }
        if (oaDepartment.getParentId().equals(0) || oaDepartment.getParentId() == null) {
            return oaDepartment;
        }
        return getPrimaryDepartment(departmentMap, departmentMap.get(oaDepartment.getParentId()));
    }

    @Rollback(value = false)
    @Test
    public void importMallProduct() {
        TypeListener typeListener = new TypeListener();
        EasyExcel.read("/Users/huluobin/费用类型.xlsx", TypeItem.class, typeListener).sheet().doRead();

    }

    @Data
    public static class TypeItem {

        @ExcelProperty("desc")
        private String desc;

        @ExcelProperty("type")
        private String type;

        @ExcelProperty(value = "account_type")
        private String accountType;

        @ExcelProperty(value = "cost_type")
        private Integer costType;

    }

    public static class TypeListener extends AnalysisEventListener<TypeItem> {

        private static final Logger LOGGER = LoggerFactory.getLogger(TypeListener.class);

        TypeListener() {

        }

        private static final int BATCH_COUNT = 2000;
        List<TypeItem> list = new ArrayList<>();

        @Override
        public void invoke(TypeItem data, AnalysisContext context) {
            LOGGER.info("解析到一条数据:{}", JSON.toJSONString(data));
            list.add(data);
            if (list.size() >= BATCH_COUNT) {
                syncData();
                list.clear();
            }
        }

        @Override
        public void doAfterAllAnalysed(AnalysisContext context) {
            syncData();
            LOGGER.info("所有数据解析完成！");
        }

        private void syncData() {

            Map<Integer, Integer> map = new HashMap<>();
            map.put(1, CostTypeDomain.FEE_TYPE);
            map.put(2, CostTypeDomain.INCOME_TYPE);
            map.put(3, CostTypeDomain.BORROW);

            list.forEach(item -> {
                AccountingSubjectMapper accountingSubjectMapper = SpringContextUtil.getBean(AccountingSubjectMapper.class);
                AccountingSubject accountingSubject = accountingSubjectMapper.selectByName(item.getAccountType());
                if (accountingSubject == null) {
                    accountingSubject = new AccountingSubject();
                    accountingSubject.setName(item.getAccountType());
                    accountingSubject.setSubjectNo(IdWorker.getIdStr());
                    accountingSubjectMapper.insert(accountingSubject);
                }
                CostTypeDao costTypeDao = SpringContextUtil.getBean(CostTypeDao.class);

                CostTypeDomain costTypeDomain = costTypeDao.selectOne(new LambdaQueryWrapper<CostTypeDomain>()
                        .eq(CostTypeDomain::getTypeName, item.getType())
                        .eq(CostTypeDomain::getCostTemplateType, map.get(item.getCostType()))
                        .eq(CostTypeDomain::getAccountingSubjectId, accountingSubject.getId()));

                if (costTypeDomain == null) {
                    costTypeDomain = new CostTypeDomain();
                }

                costTypeDomain.setCostTemplateType(map.get(item.getCostType()));
                costTypeDomain.setTypeName(item.getType());
                costTypeDomain.setTypeNo(IdWorker.getIdStr());
                costTypeDomain.setDescription(item.getDesc());
                costTypeDomain.setAccountingSubjectId(accountingSubject.getId());

                boolean b = costTypeDao.updateById(costTypeDomain) > 0 || costTypeDao.insert(costTypeDomain) > 0;

            });
        }
    }


    @Rollback(value = false)
    @Test
    public void importCost() {
        CostListener costListener = new CostListener();
        EasyExcel.read("/Users/huluobin/Library/Containers/com.tencent.WeWorkMac/Data/Library/Application Support/WXWork/Data/1688853793439460/Cache/File/2021-01/1月份费用系统数据更新V1.xls", CostItem.class, costListener).sheet().doRead();
    }

    @Data
    public static class CostItem {

        @ExcelProperty("费用单号")
        private String costNo;

        @ExcelProperty("费用类别new")
        private String typeName;

        @ExcelProperty("会计科目new")
        private String accountSubjectName;
    }

    public static class CostListener extends AnalysisEventListener<CostItem> {
        private static final Logger LOGGER = LoggerFactory.getLogger(CostListener.class);

        CostListener() {

        }

        private static final int BATCH_COUNT = 100;
        List<CostItem> list = new ArrayList<>();

        @Override
        public void invoke(CostItem data, AnalysisContext context) {
            LOGGER.info("解析到一条数据:{}", JSON.toJSONString(data));
            list.add(data);
            if (list.size() >= BATCH_COUNT) {
                syncData();
                list.clear();
            }
        }

        @Override
        public void doAfterAllAnalysed(AnalysisContext context) {
            syncData();
            LOGGER.info("所有数据解析完成！");
        }

        private void syncData() {
            list.forEach(item -> {
                CostDao costDao = SpringContextUtil.getBean(CostDao.class);
                CostTypeDao costTypeDao = SpringContextUtil.getBean(CostTypeDao.class);

                CostDomain costDomain = costDao.selectByCostNo(item.getCostNo());
                costDomain.setAccountingSubjectName(item.getAccountSubjectName());
                costDomain.setTypeName(item.getTypeName());

                CostTypeDomain costTypeDomain = costTypeDao.selectByTypeNameAndAccountSubjectName(item.getTypeName(), item.getAccountSubjectName());
                if (costTypeDomain != null) {
                    costDomain.setTypeId(costTypeDomain.getId());
                }

                costDomain.setLastModifyDate(LocalDateTime.now());
                costDao.updateById(costDomain);
            });
        }
    }


    @Resource
    CostDao costDao;
    @Resource
    CostCurrentReviewerMapper costCurrentReviewerMapper;
    @Resource
    CostCompanyDao costCompanyDao;
    @Resource
    OaUserMapper oaUserMapper;

    @Test
    @Rollback(value = false)
    public void syncOldCost() {
        List<CostDomain> costDomains1 = costDao.selectByStatus(CostDomain.STATUS_DEPARTMENT_CHECK);

        costDomains1.forEach(costDomain -> {

            OaUser oaUser = oaUserMapper.selectByOaUserId(costDomain.getCreateUserid());
            List<CostReviewer> costReviewerList = costReviewerMapper.selectList(new LambdaQueryWrapper<CostReviewer>()
                    .eq(CostReviewer::getType, 1)
                    .eq(CostReviewer::getReferId, oaUser.getPrimaryDepartmentId()));

            costReviewerList.forEach(costReviewer -> {
                CostCurrentReviewer costCurrentReviewer = new CostCurrentReviewer();
                costCurrentReviewer.setUsername(costReviewer.getReviewerUserName());
                costCurrentReviewer.setOaUserId(costReviewer.getReviewerUserId());
                costCurrentReviewer.setCostNo(costDomain.getCostNo());
                costCurrentReviewerMapper.insert(costCurrentReviewer);
            });
        });

        List<CostDomain> costDomains2 = costDao.selectByStatus(CostDomain.STATUS_FINANCIAL_CHECK);

        costDomains2.forEach(costDomain -> {
            CostCompanyDomain costCompanyDomain = costCompanyDao.selectByNo(costDomain.getCompanyNo());

            List<CostReviewer> costReviewerList = costReviewerMapper.selectList(new LambdaQueryWrapper<CostReviewer>()
                    .eq(CostReviewer::getType, CostReviewer.financialReviewer)
                    .eq(CostReviewer::getReferId, costCompanyDomain.getId()));

            costReviewerList.forEach(costReviewer -> {
                CostCurrentReviewer costCurrentReviewer = new CostCurrentReviewer();
                costCurrentReviewer.setUsername(costReviewer.getReviewerUserName());
                costCurrentReviewer.setOaUserId(costReviewer.getReviewerUserId());
                costCurrentReviewer.setCostNo(costDomain.getCostNo());
                costCurrentReviewerMapper.insert(costCurrentReviewer);
            });
        });

        List<CostDomain> costDomains3 = costDao.selectByStatus(CostDomain.STATUS_HR_CHECK);

        costDomains3.forEach(costDomain -> {
            CostCompanyDomain costCompanyDomain = costCompanyDao.selectByNo(costDomain.getCompanyNo());

            List<CostReviewer> costReviewerList = costReviewerMapper.selectList(new LambdaQueryWrapper<CostReviewer>()
                    .eq(CostReviewer::getType, CostReviewer.hrReviewer)
                    .eq(CostReviewer::getReferId, costCompanyDomain.getId()));

            costReviewerList.forEach(costReviewer -> {
                CostCurrentReviewer costCurrentReviewer = new CostCurrentReviewer();
                costCurrentReviewer.setUsername(costReviewer.getReviewerUserName());
                costCurrentReviewer.setOaUserId(costReviewer.getReviewerUserId());
                costCurrentReviewer.setCostNo(costDomain.getCostNo());
                costCurrentReviewerMapper.insert(costCurrentReviewer);
            });
        });

        List<CostDomain> costDomains4 = costDao.selectByStatus(CostDomain.STATUS_FINAL_CHECK);

        costDomains4.forEach(costDomain -> {
            CostCompanyDomain costCompanyDomain = costCompanyDao.selectByNo(costDomain.getCompanyNo());

            List<CostReviewer> costReviewerList = costReviewerMapper.selectList(new LambdaQueryWrapper<CostReviewer>()
                    .eq(CostReviewer::getType, CostReviewer.finalReviewer)
                    .eq(CostReviewer::getReferId, costCompanyDomain.getId()));

            costReviewerList.forEach(costReviewer -> {
                CostCurrentReviewer costCurrentReviewer = new CostCurrentReviewer();
                costCurrentReviewer.setUsername(costReviewer.getReviewerUserName());
                costCurrentReviewer.setOaUserId(costReviewer.getReviewerUserId());
                costCurrentReviewer.setCostNo(costDomain.getCostNo());
                costCurrentReviewerMapper.insert(costCurrentReviewer);
            });
        });
    }

    @Resource
    MailService mailService;

    @Test
    public void testMail() {
        mailService.sendSimpleMail("robbendev@qq.com", "pre", "test");
    }

    @Resource
    CostTypeDao costTypeDao;

    @Resource
    CostCashiercallbackDao costCashiercallbackDao;


    @Test
    @Rollback(value = false)
    public void test() {
        String[] costs = new String[]{"F023173","F025275","F025276","F025849","F026224","F026229","F035840","F036998","F037056","F037145","F037207","F037253","F037353","F037361","F037451","F037452","F037453","F037456","F037540","F037715","F037768","F037847","F037859","F037888","F038035","F038092","F038095","F038097","F038113","F038114","F038118","F038201"};
        for(String cost : costs){
            CostDomain costDomain = costDao.selectByCostNo(cost);
            List<CostDetailDomain> costDetailDomainList = costDetailDao.selectListByCostNo(cost);
            costDomain.setCostDetailDomainList(costDetailDomainList);
            CostCashiercallbackDomain costCashiercallbackDomain = costCashiercallbackDao.selectByCostNo(cost);
            CostTypeResult costTypeResult = costTypeDao.queryDetail(costDomain.getTypeId());

            if (costDomain.getCompanyValue() != 2) {
                continue;
            }
            //xgbl代表香港百伦
            String companyCode = "xgbl";


            String nsAccountingSubjectId = costCashiercallbackDomain.getErpAccountingType();

            if(costCashiercallbackDomain.getCashierbankcardname().equals("Hang Seng Bank Limited")
                    && costCashiercallbackDomain.getCashierbankcard().equals("774-515290-883")){
                switch (costCashiercallbackDomain.getCashierunitcode().toUpperCase()){
                    case "HKD":
                        nsAccountingSubjectId = "10020201";
                        break;
                    case "EUR":
                        nsAccountingSubjectId = "10020202";
                        break;
                    case "USD":
                        nsAccountingSubjectId = "10020203";
                        break;
                    case "GBP":
                        nsAccountingSubjectId = "10020204";
                        break;
                    case "CNY":
                        nsAccountingSubjectId = "10020205";
                        break;
                    case "AUD":
                        nsAccountingSubjectId = "10020207";
                        break;
                }
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
            NetsuiteDataDto netsuiteDataDto = new NetsuiteDataDto();
            netsuiteDataDto.setTranid(costDomain.getCostNo());
            netsuiteDataDto.setCurrency("CNY");
            netsuiteDataDto.setSubsidiary(companyCode);
            netsuiteDataDto.setTrandate(sdf.format(costDomain.getActualTime()));
            netsuiteDataDto.setCustbody_iofeetype(costDomain.getCostForm().toString());

            //费用详情
            List<NetsuiCostinfoDto> netsuiCostInfoDtos = new ArrayList<>();
            //费用系统信息
            NetsuiCostinfoDto feeSysInfo = new NetsuiCostinfoDto(
                    costTypeResult.getNsAccountingSubjectId().toString(),
                    costDomain.getAmount().toString(),
                    costDomain.getCostReason()
            );
            netsuiCostInfoDtos.add(feeSysInfo);
            //财务系统信息
            NetsuiCostinfoDto cwSysInfo = new NetsuiCostinfoDto(
                    nsAccountingSubjectId,
                    costCashiercallbackDomain.getPayamount().toString(),
                    costCashiercallbackDomain.getPaynote()
            );
            netsuiCostInfoDtos.add(cwSysInfo);

            netsuiteDataDto.setCostinfo(netsuiCostInfoDtos);
            NetsuiteLogDomain netsuiteLogDomain = new NetsuiteLogDomain();
            netsuiteLogDomain.setCostNo(costDomain.getCostNo());
            netsuiteLogDomain.setPublishStatus(NetsuiteLogDomain.UNPUBLISH);
            netsuiteLogDomain.setScript(NetsuiteLogDomain.SCRIPT_FEE);
            netsuiteLogDomain.setJsonStr(JSON.toJSONString(netsuiteDataDto));
            netsuiteLogDao.upsert(netsuiteLogDomain);
        }

    }

    public void nsLogModify(){
        List<NetsuiteLogDomain> list = netsuiteLogService.list(new LambdaQueryWrapper<NetsuiteLogDomain>().eq(NetsuiteLogDomain::getPublishStatus,NetsuiteLogDomain.FAILURE));

        list.forEach(x ->{
            NetsuiteDataDto netsuiteDataDto = JsonUtilByJackson.readValue(x.getJsonStr(),NetsuiteDataDto.class);

        });
    }

    @Test
    public void testAny(){
        BigDecimal val1 = new BigDecimal("2000");
        BigDecimal val2 = new BigDecimal("100");
        boolean compare1 = !(val1.compareTo(BigDecimal.ZERO) > 0 && val2.compareTo(val1) < 0);
        System.out.println(compare1);
    }

    @Rollback(value = false)
    @Test
    public void publishToNetsuiteTest() {
        netsuiteLogService.publishToNetsuite(100);
    }

    @Rollback(value = false)
    @Test
    public void testType() {

        costTypeDao.selectTestType()
                .forEach(costTypeDomain -> {
                    CostTypeDomain item = new CostTypeDomain();
                    item.setCostTemplateType(CostTypeDomain.BORROW);
                    item.setDescription(costTypeDomain.getDescription());
                    item.setTypeNo(IdWorker.getIdStr());
                    item.setTypeName(costTypeDomain.getTypeName());
                    costTypeDao.insert(item);
                });
    }

    @Resource
    IDepartmentReviewerService departmentReviewerService;

    @Test
    @Rollback(value = false)
    public void testOaDepartment() {
        departmentReviewerMapper.delete(new LambdaQueryWrapper<>());
        costReviewerMapper.delete(new LambdaQueryWrapper<CostReviewer>().eq(CostReviewer::getType, CostReviewer.departmentReviewer));
        List<OaDepartment> oaDepartmentList = oaDepartmentService.list(new LambdaQueryWrapper<OaDepartment>()
                .eq(OaDepartment::getParentId, 0));

        oaDepartmentList.forEach(oaDepartment -> {
            DepartmentReviewer departmentReviewer = new DepartmentReviewer();
            departmentReviewer.setPrimaryDepartmentId(oaDepartment.getDepartmentId());
            departmentReviewer.setPrimaryDepartmentName(oaDepartment.getName());
            departmentReviewer.setSecondDepartmentName("全部");
            departmentReviewer.setSecondDepartmentId(0);
            departmentReviewerService.save(departmentReviewer);

            OaUser oaUser = oaUserMapper.selectByUserName(oaDepartment.getManageUser1());
            CostReviewer costReviewer = new CostReviewer();
            costReviewer.setType(CostReviewer.departmentReviewer);
            costReviewer.setReferId(departmentReviewer.getId());
            costReviewer.setReviewerUserId(oaUser.getOaUserId());
            costReviewer.setReviewerUserName(oaUser.getUserName());
            costReviewerMapper.insert(costReviewer);
        });

    }

    @Test
    public void exportDepartmentReviewer() {

        DepartmentReviewerListReq req = new DepartmentReviewerListReq();
        req.setPageNum(1);
        req.setPageSize(100);
        List<DepartmentReviewerListItem> list = departmentReviewerService.departmentReviewerList(req).getRecords();
        list.forEach(item -> item.setCostReviewerNames(item.getCostReviewerList().stream().map(CostReviewer::getReviewerUserName).collect(Collectors.joining(","))));

        EasyExcel.write("/Users/huluobin/exportDepartmentReviewer.xlsx", DepartmentReviewerListItem.class).sheet("sheet").doWrite(list);

    }

    @Autowired
    private RabbitTemplate rabbitTemplate;

    @Resource
    private DefaultSendService sendService;

    @Resource
    private DefaultRegisterQueueService registerQueueService;

    @Test
    public void rabbitMqTest() {
        for (int i = 0; i < 10; i++) {
            DepartmentReviewerListReq req = new DepartmentReviewerListReq();
            req.setPageNum(i);
            req.setPageSize(100);
            sendService.send("com.bailuntec.fee", "com.bailuntec.fee.netsuite.task", req, null, null);
        }

    }

    @Test
    public void rabbitMqTest1() {
        boolean isRegister = registerQueueService
                .exchange("com.bailuntec.fee")
                .queue("com.bailuntec.fee.netsuite.task")
                .routingKey("com.bailuntec.fee.netsuite.task")
                .registerQueue();
        while (true) ;

    }

}

