package com.blt.other.module.cost.service.impl;

import com.bailuntec.common.BeanUtils;
import com.bailuntec.common.ListUtil;
import com.bailuntec.common.StringUtils;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.blt.other.common.exception.BizRuntimeException;
import com.blt.other.common.util.PathUtil;
import com.blt.other.database.model.CostTypeDomain;
import com.blt.other.module.cost.dao.AccountingSubjectMapper;
import com.blt.other.module.cost.dao.CostDao;
import com.blt.other.module.cost.dao.CostDetailDao;
import com.blt.other.module.cost.dao.CostTypeDao;
import com.blt.other.module.cost.dto.request.ResetReq;
import com.blt.other.module.cost.dto.response.ResetResp;
import com.blt.other.module.cost.model.AccountingSubject;
import com.blt.other.module.cost.model.CostDetailDomain;
import com.blt.other.module.cost.model.CostDomain;
import com.blt.other.module.cost.service.CostDetailService;
import com.blt.other.module.cost.service.CostService;
import com.blt.other.module.cost.utils.CostFileUtil;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Service
public class CostDetailServiceImpl extends ServiceImpl<CostDetailDao, CostDetailDomain> implements CostDetailService {

    @Resource
    private CostDetailDao costDetailDao;
    @Resource
    CostService costService;

    @Override
    public List<CostDetailDomain> getCostDetailListByCostNo(String costNo) {
        return costDetailDao.selectListByCostNo(costNo);
    }

    @Override
    public CostDetailDomain getCostDetailByDetailNo(String detailNo) {
        return costDetailDao.selectByDetailNo(detailNo);
    }


    @Transactional
    @Override
    public Integer update(CostDetailDomain domain) {
        //更新费用单
        return costDetailDao.update(domain, new LambdaQueryWrapper<CostDetailDomain>()
                .eq(CostDetailDomain::getDetailNo, domain.getDetailNo()));
    }

    @Resource
    CostTypeDao costTypeDao;
    @Resource
    AccountingSubjectMapper accountingSubjectMapper;
    @Resource
    CostDao costDao;

    @Override
    public ResetResp reset(ResetReq req) {
        CostDetailDomain costDetailDomain = this.getCostDetailByDetailNo(req.getDetailNo());

        List<CostDetailDomain> costDetailDomainList = baseMapper.selectListByCostNo(costDetailDomain.getCostNo());
        if (costDetailDomainList.size() > 1) {
            throw new BizRuntimeException("大于1条不能改");
        }
        BeanUtils.copyProperties(req, costDetailDomain);

        if (req.getFileSelect2() != null) {
            // 文件上传的路径
            String filePath = PathUtil.getBasePath() + PathUtil.getPath("cost/" + costDetailDomain.getDetailNo() + "/");
            // 调用工具类执行保存，并返回 path
            String path = CostFileUtil.upload(req.getFileSelect2(), filePath);
            costDetailDomain.setFilePath(path);
        }

        if (StringUtils.isNotEmpty(req.getTypeNo())) {

            CostTypeDomain costTypeDomain = costTypeDao.selectByNo(req.getTypeNo());
            AccountingSubject accountingSubject = accountingSubjectMapper.selectById(costTypeDomain.getAccountingSubjectId());

            costDetailDomain.setTypeId(costTypeDomain.getId());
            costDetailDomain.setTypeNo(costTypeDomain.getTypeNo());
            costDetailDomain.setTypeName(costTypeDomain.getTypeName());
            costDetailDomain.setAccountingSubjectNo(accountingSubject.getSubjectNo());
            costDetailDomain.setAccountingSubjectName(accountingSubject.getName());
        }

        baseMapper.updateById(costDetailDomain);
        costService.resetCost(costDetailDomain.getCostNo());

        ResetResp resetResp = new ResetResp();
        resetResp.setDetail(costDetailDomain);
        resetResp.setSuccess(true);
        return resetResp;
    }

    @Override
    public void setDetail(List<CostDomain> costDomainList) {
        if (ListUtil.isNotEmpty(costDomainList)) {
            List<String> costNoList = costDomainList.stream().map(CostDomain::getCostNo).collect(Collectors.toList());

            List<CostDetailDomain> costDetailDomainList = baseMapper.selectList(new LambdaQueryWrapper<CostDetailDomain>()
                    .in(CostDetailDomain::getCostNo, costNoList));

            Map<String, List<CostDetailDomain>> costDetailDomainMap = costDetailDomainList.stream()
                    .collect(Collectors.groupingBy(CostDetailDomain::getCostNo));

            costDomainList.forEach(costDomain -> costDomain.setCostDetailDomainList(costDetailDomainMap.get(costDomain.getCostNo())));

        }
    }
}
