package com.blt.other.module.cost.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDateTime;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/10/15 9:12 上午
 */
public final class CostTemplateColApiReq {


    @Data
    public static class QueryListReq {

        private Integer costTemplateId;

        @ApiModelProperty("字段类目")
        private String colCategory;

        @ApiModelProperty(value = "表单字段名")
        private String colName;

        @ApiModelProperty(value = "1-单行文本 2-多行文本 3-下拉框 4-多选 5-日期 6-附件")
        private Integer colType;

        @ApiModelProperty("提示")
        private String prompt;

        private Integer createUserId;
        private Integer updateUserId;

        @ApiModelProperty(value = "是否必填")
        private Boolean isRequired;

        @ApiModelProperty("是否配置审批规则")
        private Boolean isAutoRule;

        @ApiModelProperty(value = "审批符号 类型 1 = ;2 != ;3 < ;4 <= ;5 > ;6 >= ;7 list contain (校验值用逗号分隔) ;8 ! list contain  (校验值用逗号分隔) ")
        private Integer autoRuleType;

        @DateTimeFormat(iso = DateTimeFormat.ISO.DATE_TIME)
        private LocalDateTime createTimeStart;
        @DateTimeFormat(iso = DateTimeFormat.ISO.DATE_TIME)
        private LocalDateTime createTimeEnd;

        @DateTimeFormat(iso = DateTimeFormat.ISO.DATE_TIME)
        private LocalDateTime updateTimeStart;
        @DateTimeFormat(iso = DateTimeFormat.ISO.DATE_TIME)
        private LocalDateTime updateTimeEnd;

    }
}
