package com.blt.other.other_supplier.service.impl;

import com.blt.other.other_database.model.BuyUserDomain;
import com.blt.other.other_supplier.dao.BuyUserDao;
import com.blt.other.other_supplier.service.BuyUserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class BuyUserServiceImpl implements BuyUserService {

    @Autowired
    private BuyUserDao buyUserDao;
    @Override
    public BuyUserDomain getBuyUserByUserId(Integer userid) {
        return buyUserDao.selectByUserId(userid);
    }

    /**
     * 获取所有采购员
     * @return
     */
    @Override
    public List<BuyUserDomain> getBuyUserList() {
        List<BuyUserDomain> buyUserDomainList = buyUserDao.selectAll();
        return buyUserDomainList;
    }
}
