package com.blt.other.module.cost.dto.response;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/12/17 3:31 下午
 */
@Data
public class CostTypeResult {


    @TableId(type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty("费用类型编号")
    private String typeNo;

    @ApiModelProperty("描述")
    private String description;

    @ApiModelProperty("费用类型标题")
    private String typeName;

    @ApiModelProperty(value = "会计一级类目编号")
    private String accountingSubjectNo;

    @ApiModelProperty(value = "会计一级类目名称")
    private String accountingSubjectName;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty(value = "创建时间")
    private LocalDateTime createTime;

    @ApiModelProperty(value = "创建人id")
    private Integer createUserId;

    @ApiModelProperty(value = "创建人")
    private String createUser;

    @ApiModelProperty(value = "更新人id")
    private Integer updateUserId;

    @ApiModelProperty(value = "更新人")
    private String updateUser;

    @ApiModelProperty(value = "最后更新时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime lastUpdateTime;

    @ApiModelProperty("是否管理成本")
    private Boolean isManageCost;


}
