package com.blt.other.module.cost.controller;

import com.bailuntec.cost.api.dto.CostPlanTempDto;
import com.blt.other.common.util.CurUtils;
import com.blt.other.module.cost.dto.request.GetAllCostPlanReq;
import com.blt.other.module.cost.dto.response.GetAllCostPlanResp;
import com.blt.other.module.cost.dto.response.GetCostPlanResp;
import com.blt.other.module.cost.dto.response.GetPlanTmpsResp;
import com.blt.other.module.cost.dto.response.SearchByKeyResp;
import com.blt.other.module.cost.service.CostPlanSearchService;
import com.blt.other.module.cost.service.CostPlanService;
import com.blt.other.module.cost.service.CostPlanTempService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.List;

@Api(tags = "费用计划接口")
@RestController
@RequestMapping("/cost/plan")
public class CostPlanController {

    @Resource
    private CostPlanService costPlanService;
    @Resource
    private CostPlanSearchService costPlanSearchService;
    @Resource
    private CostPlanTempService costPlanTempService;

    @ApiOperation("查询所有费用计划")
    @GetMapping("/getAllCostPlan")
    public GetAllCostPlanResp getAllCostPlan(GetAllCostPlanReq req) {
        return costPlanService.getAllCostList(req);
    }

    @ApiOperation("搜索费用计划")
    @PostMapping("/search/key")
    public SearchByKeyResp searchByKey(@RequestParam String searchKey) {
        return costPlanSearchService.searchByKey(searchKey);
    }

    @ApiOperation("根据费用计划单号查询费用计划单")
    @PostMapping("getCostPlan")
    public GetCostPlanResp getCostPlan(@RequestParam String costPlanNo) {
        return costPlanService.getByPlanNo(costPlanNo);
    }

    @ApiOperation("获取费用单计划子项")
    @PostMapping("getPlanTmps")
    public GetPlanTmpsResp getPlanTmps(@RequestParam String costPlanNo) {

        List<CostPlanTempDto> tempListByPlanNo = costPlanTempService.getTempListByPlanNo(costPlanNo).getTemps();
        BigDecimal planAmount = costPlanTempService.getTempListByPlanNo(costPlanNo).getTemps()
                .stream()
                .map(costPlanTempDto -> CurUtils.getCur(costPlanTempDto.getDic(), "CNY").multiply(costPlanTempDto.getAmount()))
                .reduce(BigDecimal.ZERO, BigDecimal::add);

        GetPlanTmpsResp resp = new GetPlanTmpsResp();
        resp.setTmps(tempListByPlanNo);
        resp.setPlanAmount(planAmount);

        return resp;
    }
}
