package com.blt.other.module.cost.controller;

import com.bailuntec.cost.api.dto.CostDto;
import com.bailuntec.cost.api.dto.CostListPrintDto;
import com.bailuntec.cost.api.response.CostResult;
import com.bailuntec.cost.api.response.CostToCwResult;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.blt.other.common.annotation.LoginIgnore;
import com.blt.other.module.cost.dto.request.CheckCostListReq;
import com.blt.other.module.cost.dto.request.CostQueryPageReq;
import com.blt.other.module.cost.dto.request.InvoiceReq;
import com.blt.other.module.cost.model.CostDomain;
import com.blt.other.module.cost.service.CostLogService;
import com.blt.other.module.cost.service.CostService;
import com.blt.other.module.cost.service.impl.cost.CostServiceFactory;
import com.blt.other.module.cost.service.impl.costcheck.*;
import com.blt.other.module.cost.vo.ApplyCallbackUrlVo;
import com.blt.other.module.cost.vo.CashierCallbackUrlVo;
import com.blt.other.module.cost.vo.CostListPrintVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/10/29 11:31 上午
 */
@RequestMapping("/cost")
@RestController
@Api(tags = "费用单接口")
public class CostController {

    @Resource
    private CostService costService;
    @Resource
    private CostLogService costLogService;
    @Resource
    private DepartmentCheckState departmentCheckState;
    @Resource
    private FinalCheckState finalCheckState;
    @Resource
    private FinancialCheckState financialCheckState;
    @Resource
    private HrCheckState hrCheckState;


    @ApiOperation("获取前端要打印的费用单列表")
    @PostMapping("/list/print/list")
    public CostResult<List<CostListPrintDto>> printList(@RequestBody CostListPrintVo costListPrintVo) {
        costService = CostServiceFactory.getCostService();
        List<CostListPrintDto> costListPrintDtoList = costService.printList(costListPrintVo.getPrintNos());
        return CostResult.success(costListPrintDtoList);
    }


    @ApiOperation("分页查询费用单")
    @PostMapping("/queryPage")
    public CostResult<Page<CostDto>> queryPage(@RequestBody CostQueryPageReq req) {
        Page<CostDomain> costDaoPage = costService.queryPage(req);
        return CostResult.success((Page<CostDto>) costDaoPage.convert(CostDomain::castToDto));
    }

    @ApiOperation("获取费用详情")
    @PostMapping("/list/getCostDetail")
    public CostResult<CostDto> getCostDetail(@RequestParam String costNo) {

        costService = CostServiceFactory.getCostService(costNo);
        CostDomain costDomain = costService.getCostByCostNo(costNo);
        return CostResult.success(costDomain.castToDto());
    }

    @ApiOperation("修改发票附件")
    @PostMapping("list/reset/resetInvoice")
    public CostResult<Void> resetInvoice(@RequestParam String costNo,
                                         @RequestParam String filePath) {
        costService = CostServiceFactory.getCostService(costNo);
        costService.resetInvoice(costNo, filePath);
        return CostResult.success();
    }


    @ApiOperation("修改费用单信息")
    @PostMapping({"reset/resetFile", "reset/resetNoFile"})
    public CostResult<Void> resetFile(@RequestBody CostDomain costDomain) {
        costService.updateCost(costDomain);
        return CostResult.success();
    }


    @ApiOperation("提交费用单")
    @PostMapping("submitAudit")
    public CostResult<Void> submitAudit(@RequestParam String costNo) {
        costService = CostServiceFactory.getCostService(costNo);
        costService.submitAudit(costNo);
        return CostResult.success();
    }

    @ApiOperation("根据费用计划查询费用单")
    @PostMapping("/getCostByCostPlanNo")
    public CostResult<List<CostDto>> getCostByCostPlanNo(@RequestParam String costPlanNo) {
        costService = CostServiceFactory.getCostService();
        List<CostDto> costDtoList = costService.getByCostPlanNo(costPlanNo);
        return CostResult.success(costDtoList);
    }

    @ApiOperation("待审核费用单列表")
    @GetMapping("/checkCostList")
    public CostResult<IPage<CostDto>> checkCostList(CheckCostListReq req) {
        costService = CostServiceFactory.getCostService();
        IPage<CostDto> page = costService.checkCostList(req);
        return CostResult.success(page);
    }

    @ApiOperation("审核费用单列表")
    @GetMapping("/checkCostCount")
    public CostResult<Long> checkCostCount(CheckCostListReq req) {
        costService = CostServiceFactory.getCostService();
        Long count = costService.checkCostList(req).getTotal();
        req.setType(1);
        Long count1 = costService.checkCostList(req).getTotal();
        return CostResult.success(count + count1);
    }

    @ApiOperation("部门审核通过")
    @GetMapping("/check/departmentCheck")
    public CostResult<Void> departmentCheck(@RequestParam String costNo,
                                            @RequestParam Integer userid) {
        CostContext costContext = new CostContext(costNo, userid);
        costContext.setCostState(departmentCheckState);
        costContext.handle();
        return CostResult.success();
    }

    @GetMapping("/check/departmentRefuse")
    @ApiOperation("部门审核驳回")
    public CostResult<Void> departmentCheckRefuse(@RequestParam String costNo,
                                                  @RequestParam Integer userid,
                                                  @RequestParam String rejectReason) {
        CostContext costContext = new CostContext(costNo, userid);
        costContext.setCostState(departmentCheckState);
        costContext.refuse(rejectReason);

        return CostResult.success();
    }

    @GetMapping("/check/financialCheck")
    @ApiOperation("财务审核通过")
    public CostResult<Void> financialCheck(@RequestParam String costNo,
                                           @RequestParam Integer userid) {
        CostContext costContext = new CostContext(costNo, userid);
        costContext.setCostState(financialCheckState);
        costContext.handle();
        return CostResult.success();
    }

    @GetMapping("/check/financialRefuse")
    @ApiOperation("财务审核驳回")
    public CostResult<Void> financialRefuse(@RequestParam String costNo,
                                            @RequestParam Integer userid,
                                            @RequestParam String rejectReason) {
        CostContext costContext = new CostContext(costNo, userid);
        costContext.setCostState(financialCheckState);
        costContext.refuse(rejectReason);
        return CostResult.success();
    }

    @GetMapping("/check/finalCheck")
    @ApiOperation("最终审核通过")
    public CostResult<Void> finalCheck(@RequestParam String costNo,
                                       @RequestParam Integer userid) {
        CostContext costContext = new CostContext(costNo, userid);
        costContext.setCostState(finalCheckState);
        costContext.handle();
        return CostResult.success();
    }

    @GetMapping("/check/finalRefuse")
    @ApiOperation("最终审核人驳回")
    public CostResult<Void> finalRefuse(@RequestParam String costNo,
                                        @RequestParam Integer userid,
                                        @RequestParam String rejectReason) {
        CostContext costContext = new CostContext(costNo, userid);
        costContext.setCostState(finalCheckState);
        costContext.refuse(rejectReason);
        return CostResult.success();
    }

    @GetMapping("/check/hrCheck")
    @ApiOperation("行政审核通过")
    public CostResult<Void> hrCheck(@RequestParam String costNo,
                                    @RequestParam Integer userid) {
        CostContext costContext = new CostContext(costNo, userid);
        costContext.setCostState(hrCheckState);
        costContext.handle();
        return CostResult.success();
    }

    @GetMapping("/check/hrCheckRefuse")
    @ApiOperation("行政审核驳回")
    public CostResult<Void> hrCheckRefuse(@RequestParam String costNo,
                                          @RequestParam Integer userid,
                                          @RequestParam String rejectReason) {
        CostContext costContext = new CostContext(costNo, userid);
        costContext.setCostState(hrCheckState);
        costContext.refuse(rejectReason);
        return CostResult.success();
    }

    @ApiOperation("删除费用单")
    @PostMapping("/list/deleted")
    public CostResult<Void> deleted(@RequestParam String costNo) {
        costService = CostServiceFactory.getCostService(costNo);

        costService.setStatus(costNo, 5);
        costLogService.save(costNo, costService.getCostByCostNo(costNo).getCreateUserid(), "作废费用单");
        return CostResult.success();
    }

    @LoginIgnore
    @ApiOperation("财务审核回调")
    @PostMapping({"check/ApplyCallbackUrl", "check/lendCashierCallbackUrl"})
    public CostToCwResult<Boolean> applyCallbackUrl(@RequestBody ApplyCallbackUrlVo applyCallbackUrlVo) {
        costService.applyCallback(applyCallbackUrlVo);
        return CostToCwResult.success();
    }

    @LoginIgnore
    @ApiOperation("财务付款回调接口")
    @PostMapping(value = {"check/CashierCallbackUrl", "check/lend/CashierCallbackUrl"})
    public CostToCwResult<Boolean> cashierCallbackUrl(@RequestBody CashierCallbackUrlVo cashierCallbackUrlVo) {
        costService.cashierCallback(cashierCallbackUrlVo);
        return CostToCwResult.success();
    }


    @ApiOperation("修改发票状态")
    @PostMapping(value = "/check/lend/invoice")
    public CostResult<Void> invoice(@RequestBody InvoiceReq req) {
        costService = CostServiceFactory.getCostService(req.getCostNo());
        costService.invoice(req);
        return CostResult.success();

    }

}
