package com.blt.other.module.log.model;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.bson.codecs.pojo.annotations.BsonId;
import org.bson.codecs.pojo.annotations.BsonIgnore;
import org.bson.types.ObjectId;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.MongoId;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Map;

/**
 * @Author: li.yanlin
 * @Description：
 * @Date: Created in
 * @Modified by:
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@Document
public class OperationLog implements Serializable {

    @MongoId
    private ObjectId _id;

    private String userId;

    private String sourceFrom;

    private String ip;

    private String userAgent;

    private String url;

    private byte[] input;

    private Map<String, String[]> params;

    private LocalDateTime createTime;
}
