package com.blt.other.common.interceptor;

import com.blt.other.common.annotation.LoginIgnore;
import com.blt.other.common.base.SysUser;
import com.blt.other.common.exception.BizRuntimeException;
import com.blt.other.common.util.JwtUtil;
import com.blt.other.common.util.SessionUtils;
import com.blt.other.module.auth.dao.OaUserMapper;
import com.blt.other.module.auth.model.OaUser;
import com.google.common.collect.Lists;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.lang.reflect.Method;

@Component
@AllArgsConstructor
@Slf4j
public class SessionHandlerInterceptor implements HandlerInterceptor {

    @Resource
    OaUserMapper oaUserMapper;

    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {

        try {
            HandlerMethod handlerMethod = (HandlerMethod) handler;
            Method method = handlerMethod.getMethod();
            if (method.isAnnotationPresent(LoginIgnore.class)) {
                return true;
            }

            String token = Lists.newArrayList(request.getHeader("Cookie").split(";"))
                    .stream()
                    .filter(item -> item.contains("BailunToken"))
                    .findAny()
                    .map(item -> item.replaceAll("BailunToken=", "").trim())
                    .orElseThrow(() -> new BizRuntimeException("400", "请先登陆"));

            SysUser sysUser = JwtUtil.validateToken(token);
            SessionUtils.putSysUser(sysUser);
        } catch (Exception ex) {

//            String activeProfile = SpringContextUtil.getString("spring.profiles.active");
//            if (!activeProfile.equals("prod")) {
//                SysUser sysUser = new SysUser();
//                sysUser.setOaUserId(0);
//                sysUser.setUserName("系统日志");
//                SessionUtils.putSysUser(sysUser);
//                return true;
//            }
//            throw new BizRuntimeException("400", "请先登陆");

            try {
                Integer userid = Integer.valueOf(request.getHeader("userid"));
                SysUser sysUser = new SysUser();
                sysUser.setOaUserId(userid);

                OaUser oaUser = oaUserMapper.selectByOaUserId(userid);
                sysUser.setUserName(oaUser.getUserName());
                SessionUtils.putSysUser(sysUser);
            } catch (Exception ignored) {

            }
            return true;

        }
        return true;
    }

    @Override
    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        SessionUtils.removeSysUser();
    }

}
