package com.blt.other.module.cost.dao;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.blt.other.database.model.CostTypeDomain;
import com.blt.other.module.cost.dto.request.CostTypeBaseReq;
import com.blt.other.module.cost.dto.response.CostTypeResult;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

@Mapper
@Repository
public interface CostTypeDao extends BaseMapper<CostTypeDomain> {

    //分页获取费用类型
    IPage<CostTypeResult> queryPage(@Param("page") IPage<CostTypeResult> page,
                                    @Param("req") CostTypeBaseReq req);

    //获取全部费用类型
    List<CostTypeResult> queryAll(@Param("req") CostTypeBaseReq req);

    //根据编号查
    CostTypeDomain selectByNo(String typeNo);

    //获取费用类型详情
    CostTypeResult queryDetail(Integer id);

    //获取费用类型详情
    CostTypeResult queryByNo(String typeNo);

    //根据费用类型名称和类型查询
    CostTypeDomain selectByNameAndType(@Param("name") String name, @Param("type") Integer type);

    //
    List<CostTypeDomain> selectTestType();

    CostTypeDomain selectByTypeNameAndAccountSubjectName(@Param("typeName") String typeName, @Param("accountSubjectName") String accountSubjectName);
}
