package com.blt.other.module.cost.service.impl.costcheck;

import com.bailuntec.common.StringUtils;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.blt.other.common.config.property.WxWebHook;
import com.blt.other.common.exception.BizRuntimeException;
import com.blt.other.database.model.CostCompanyDomain;
import com.blt.other.database.model.CostLogDomain;
import com.blt.other.database.model.UserDomain;
import com.blt.other.module.auth.dao.UserDao;
import com.blt.other.module.cost.dao.CostCompanyDao;
import com.blt.other.module.cost.dao.CostCurrentReviewerMapper;
import com.blt.other.module.cost.model.ApprovalHistoryDomain;
import com.blt.other.module.cost.model.CostCurrentReviewer;
import com.blt.other.module.cost.model.CostDomain;
import com.blt.other.module.cost.model.CostTemplate;
import com.blt.other.module.cost.service.ApprovalHistoryService;
import com.blt.other.module.sys.model.CostReviewer;
import org.springframework.context.annotation.Scope;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.client.RestTemplate;

import javax.annotation.Resource;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/10/30 2:57 下午
 */
@Component
@Scope("prototype")
public class FinancialCheckState extends CostState {


    @Resource
    FinalCheckState finalCheckState;
    @Resource
    FactoryCheckState factoryCheckState;
    @Resource
    CostCompanyDao costCompanyDao;
    @Resource
    CostCurrentReviewerMapper costCurrentReviewerMapper;
    @Resource
    ApprovalHistoryService approvalHistoryService;

    @Resource
    WxWebHook webHook;
    @Resource
    RestTemplate restTemplate;
    @Resource
    UserDao userDao;

    private void sendWxMsg(CostDomain costDomain, Integer currentUserId) {
        UserDomain userDomain = userDao.selectByuserid(currentUserId);
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        String msg = String.format("{\n" +
                        "    \"msgtype\": \"markdown\",\n" +
                        "    \"markdown\": {\n" +
                        "        \"content\": \"单号【<font color=\\\"info\\\">%s</font>】通过人工操作财务审核。\\n" +
                        ">审核人: <font color=\\\"info\\\">%s</font>\\n" +
                        ">审核时间: <font color=\\\"info\\\">%s</font>\"" +
                        "    }\n" +
                        "}", costDomain.getCostNo(),
                userDomain == null ? currentUserId : userDomain.getUsername(),
                LocalDateTime.now().format(dtf));
        restTemplate.getMessageConverters().set(1, new StringHttpMessageConverter(StandardCharsets.UTF_8));
        restTemplate.postForEntity(webHook.getUrl() + webHook.getFinalReview(), msg, Object.class);
    }

    @Override
    void nextState(CostState costState) {
        super.nextState(costState);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public void handle(String reason) {
        CostDomain costDomain = costContext.costDomain;
        Integer currentUserId = costContext.currentUserId;
        CostTemplate costTemplate = costTemplateService.queryDetail(costDomain.getCostTemplateId());

        //check status
        if (!costDomain.getCostStatus().equals(CostDomain.STATUS_FINANCIAL_CHECK)) {
            throw new BizRuntimeException("invalid status");
        }

        //需要自动审核
        if (costTemplate.shouldFinancialAutoCheck(costDomain)) {
            //自动审核通过
            if (this.autoCheck(costDomain)) {
                costDomain.setCostStatus(super.isFactory(costDomain.getCompanyNo()) && !costDomain.getCostForm().equals(2) ? CostDomain.STATUS_FACTORY_CHECK : CostDomain.STATUS_FINAL_CHECK);
                costDomain.setLastModifyDate(LocalDateTime.now());
                costDao.updateById(costDomain);

                List<CostCurrentReviewer> costCurrentReviewerList = costCurrentReviewerMapper.selectByCostNo(costDomain.getCostNo());
                costLogService.saveByManage(costDomain.getCostNo(), "财务自动审核通过,当前审核人:" + costCurrentReviewerList.stream().map(CostCurrentReviewer::getUsername)
                        .collect(Collectors.joining(",")), CostLogDomain.DEPARTMENT_AUTO_PASS);
                //流转状态
                nextState(super.isFactory(costDomain.getCompanyNo()) && !costDomain.getCostForm().equals(2) ? factoryCheckState : finalCheckState);
                //发布到总线尝试下个环节的自动审核
                costSubscribe.subscribe(costContext);
                return;
            }

        }

        if (costContext.currentUserId != null) {
            //人工审核通过
            if (costCurrentReviewerService.canAudit(currentUserId, costDomain.getCostNo())) {
                ApprovalHistoryDomain approvalHistoryDomain = ApprovalHistoryDomain.builder()
                        .approvalUserId(currentUserId)
                        .approvalTime(LocalDateTime.now())
                        .costStatus(costDomain.getCostStatus())
                        .costNo(costDomain.getCostNo())
                        .isPassed(true)
                        .build();
                costDomain.setCostStatus(super.isFactory(costDomain.getCompanyNo()) && !costDomain.getCostForm().equals(2) ? CostDomain.STATUS_FACTORY_CHECK : CostDomain.STATUS_FINAL_CHECK);
                costDomain.setLastModifyDate(LocalDateTime.now());
                costDao.updateById(costDomain);

                costLogService.save(costDomain.getCostNo(), currentUserId, "财务审核通过" + (StringUtils.isNotBlank(reason) ? (":" + reason) : ""), CostLogDomain.FINANCIAL_MANUAL_PASS);
                sendWxMsg(costDomain, currentUserId);
                approvalHistoryService.save(approvalHistoryDomain);
                //流转状态
                nextState(super.isFactory(costDomain.getCompanyNo()) && !costDomain.getCostForm().equals(2) ? factoryCheckState : finalCheckState);
                //发布到总线尝试下个环节的自动审核
                costSubscribe.subscribe(costContext);
            }
            //人工审核没权限
            else {
                throw new BizRuntimeException("current user no authority");
            }
        }
    }

    @Override
    public void refuse(String rejectReason) {
        CostDomain costDomain = costContext.costDomain;
        Integer currentUserId = costContext.currentUserId;

        CostCompanyDomain costCompany = costCompanyDao.selectByNo(costDomain.getCompanyNo());

        //check status
        if (!costDomain.getCostStatus().equals(CostDomain.STATUS_FINANCIAL_CHECK)) {
            throw new BizRuntimeException("invalid status");
        }

        //人工审核通过
        if (!costCurrentReviewerService.canAudit(currentUserId, costDomain.getCostNo())) {
            throw new BizRuntimeException("current user no authority");
        }
        ApprovalHistoryDomain approvalHistoryDomain = ApprovalHistoryDomain.builder()
                .approvalUserId(currentUserId)
                .approvalTime(LocalDateTime.now())
                .costStatus(costDomain.getCostStatus())
                .costNo(costDomain.getCostNo())
                .isPassed(false)
                .build();
        approvalHistoryService.save(approvalHistoryDomain);
        costContext.costService.reject(costDomain.getCostNo());
        costLogService.save(costDomain.getCostNo(), currentUserId, "财务审核拒绝,理由:" + rejectReason, CostLogDomain.TYPE_UPDATE);

    }

    @Override
    public void updateCurrentReviewer() {
        CostDomain costDomain = costContext.costDomain;
        CostCompanyDomain costCompanyDomain = costCompanyDao.selectByNo(costDomain.getCompanyNo());


        List<CostReviewer> costReviewerList = costReviewerMapper.selectList(new LambdaQueryWrapper<CostReviewer>()
                .eq(CostReviewer::getReferId, costCompanyDomain.getId())
                .eq(CostReviewer::getType, CostReviewer.financialReviewer));

        costCurrentReviewerService.updateByCostNoAndReviewer(costDomain.getCostNo(), costReviewerList);
//        costLogService.save(costDomain.getCostNo(), costContext.currentUserId, "财务审核人:" + costReviewerList.stream().map(CostReviewer::getReviewerUserName).collect(Collectors.joining(",")));


    }
}
