package com.blt.other.module.cost.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.blt.other.database.model.CostTypeDomain;
import com.blt.other.module.cost.dto.request.*;
import com.blt.other.module.cost.dto.response.CostTypeResult;
import com.blt.other.module.cost.dto.response.GetLogisticsBankResp;
import com.blt.other.module.cost.dto.response.GetLogisticsCodeResp;
import org.apache.ibatis.annotations.Param;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;

public interface CostTypeService extends IService<CostTypeDomain> {

    /**
     * 添加费用类型
     *
     * @param req req
     */
    void addCostType(CostTypeAddReq req);


    /**
     * 分页获取费用类型
     *
     * @param req req
     * @return resp
     */
    Page<CostTypeResult> queryPage(CostTypeQueryPageReq req);

    /**
     * 更新费用类型 （费用类型 或者 会计科目类型）
     *
     * @param req req
     */
    void modifyCostType(CostTypeModifyReq req);

    /**
     * 获取费用类型详情
     *
     * @param id id
     * @return res
     */
    CostTypeResult queryDetail(Integer id);

    /**
     * 删除费用类型详情
     *
     * @param id id
     */
    void deleteById(Integer id);

    /**
     * 根据编码获取费用费用详情
     *
     * @param typeNo typeNo
     * @return res
     */
    CostTypeResult queryByNo(String typeNo);

    /**
     * 根据名称和模板类型获取费用费用详情
     * @param typeName
     * @param costTemplateType
     * @return
     */
    List<CostTypeResult> queryByTypeName(String typeName, Integer costTemplateType);

    /**
     * 获取物流subjectCode
     *
     * @return rs
     */
    GetLogisticsCodeResp getLogisticsCode();


    /**
     * 获取物流subjectCode
     * 获取物流银行帐号
     *
     * @param subSupplierName 供应商名称
     * @return res
     */
    GetLogisticsBankResp getLogisticsBank(String subSupplierName);

    /**
     * 批量导入
     *
     * @param excel excel
     * @throws IOException ex
     */
    void importExcel(CostTypeImportExcelReq excel) throws IOException;

    /**
     * 导出
     *
     * @param response res
     * @param req      re
     * @throws IOException ex
     */
    void exportExcel(HttpServletResponse response, CostTypeExportExcelReq req) throws IOException;

}
