package com.blt.other.sku.service;

import com.blt.other.database.model.SkuTypeDomain;

import java.util.List;

public interface SkuTypeService {

    /**
     * 保存 sku 大类
     * @param skuTypeDomain
     * @return
     */
    Integer saveSkuType(SkuTypeDomain skuTypeDomain);

    /**
     * 根据 skuTypeNo 获取 sku 大类
     * @param skuTypeNo
     * @return
     */
    SkuTypeDomain getBySkuTypeNo(String skuTypeNo);

    /**
     * 根据 skuTypeName 获取 sku List
     * @param skuTypeName
     * @return
     */
    List<SkuTypeDomain> getListBySkuTypeName(String skuTypeName);

    /**
     * 获取所有 sku 大类
     * @return
     */
    List<SkuTypeDomain> getAllTypes();
}
