package com.blt.other.purchasing.controller;

import com.blt.other.commons.dto.FinansysDetailDtoData;
import com.blt.other.commons.utils.AxiosUtil;
import com.blt.other.commons.dto.FinansysDetailDto;
import com.blt.other.commons.utils.CurUtils;
import com.blt.other.database.model.ApplycallbackDomain;
import com.blt.other.purchasing.dto.BuyListDto;
import com.blt.other.purchasing.service.ApplycallbackService;
import com.blt.other.purchasing.service.BuyLogService;
import com.blt.other.purchasing.service.BuyService;
import com.blt.other.supplier.service.SupplierService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;

/**
 * 出纳详情接口  出纳系统获取采购单详情
 */
@RestController
@RequestMapping("purchasing/buy")
public class PurchaseBuyDetailController {
    private Logger logger = LoggerFactory.getLogger(PurchaseBuyDetailController.class);
    @Autowired
    private ApplycallbackService applycallbackService;

    @Autowired
    private BuyService buyService;
    @Autowired
    private SupplierService supplierService;
    @Autowired
    private BuyLogService buyLogService;

    @PostMapping("/detail")
    public FinansysDetailDto getBuyDetailDto(HttpServletResponse response, HttpServletRequest request) {
        AxiosUtil.setCors(response,request);
        // 获取 applyno
        String applyno = request.getParameter("code");
        System.out.println(applyno);
        applyno = applyno.toLowerCase();
        ApplycallbackDomain applycallback = applycallbackService.selectByApplyno(applyno);
        System.out.println(applycallback);
        String buyno = applycallback.getBuyno();
        System.out.println(buyno);
        BuyListDto buy = buyService.getBuyByBuyno(buyno);
        System.out.println(buy);

        FinansysDetailDto finansysDetailDto = new FinansysDetailDto();
        finansysDetailDto.setSuccess(true);
        finansysDetailDto.setMsg("");

        FinansysDetailDtoData data = new FinansysDetailDtoData();
        data.setId(buy.getId());
        data.setDepartmentName(buy.getDepartmentname());
        data.setApplyUserName(buy.getCreateusername());
        data.setBuyNo(buy.getBuyno());
        data.setImportant(buy.getIsurgencyDto());
        data.setApplyTime(buy.getCreatetime());
        data.setPayType(1);
        data.setCompanyFullName(buy.getSuppliername());
        data.setSettleAccount("");
        data.setCompanyName(buy.getSuppliername());
        data.setPayWay("");
        data.setAccount(buy.getSupplierCardno());//帐号
        data.setRemark(buy.getNote());
        data.setUnitCode("CNY");
        data.setAmount(buy.getAmount());
        try {
            data.setChineseAmount(CurUtils.digitUppercase(buy.getAmount()+""));//中文金额
        } catch (Exception e) {
            logger.error("PurchaseBuyDetailController",e);
        }
        data.setCWOperationer("");//财务
        data.setDepartmentManager("");//负责人
        data.setPayCompany(buy.getCompany());//付款主体
        data.setTaxFee(new BigDecimal(0));//增值税点
        data.setTaxPrice(buy.getAmount());//含税价
        data.setPayDay("");//付款方式，有账期
        data.setStorageTime("");//采购单完整入库时间
        data.setSupplierName(buy.getSuppliername());//供应商名称
        data.setUserName(buy.getSupplierCardusername());//姓名
        data.setBankName(buy.getSupplierBankname());//银行名称
        data.setBankCard(buy.getSupplierCardno()); //银行卡号
        data.setBalanceAmount(new BigDecimal(0));//余额
        data.setTaoBaoOrderNo("");
        // 日志
        data.setListLog(buyLogService.getListLogs(buyLogService.getListByBuyno(buyno)));

        finansysDetailDto.setData(data);
        return finansysDetailDto;
    }
}
