package com.blt.other.entrepot.controller;

import com.blt.other.entrepot.service.StorageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Map;

@RestController
@RequestMapping(value = "storage/list")
public class StorageController {

    private static Logger logger = LoggerFactory.getLogger(StorageController.class);

    @Autowired
    private StorageService storageService;

    @GetMapping("getAllStorages")
    public Map<String,Object> getAllStorages(HttpServletRequest request, HttpServletResponse response){
        String origin = request.getHeader("Origin");
        response.setHeader("Access-Control-Allow-Origin", origin);
        response.setHeader("Access-Control-Allow-Credentials","true");

        String pageNum = request.getParameter("pageNum");
        String pageSize = request.getParameter("pageSize");
        logger.warn("分页查询入库单列表"+pageSize+"   "+pageNum);

        Map<String,Object> resultMap = storageService.getAllStorage(Integer.parseInt(pageSize), Integer.parseInt(pageNum));

        return resultMap;
    }
}
