package com.blt.other.entrepot.controller;

import com.blt.other.commons.utils.AxiosUtil;
import com.blt.other.commons.utils.MyMapperUtil;
import com.blt.other.database.model.InventoryDomain;
import com.blt.other.database.model.InventoryLogDomain;
import com.blt.other.entrepot.dto.InventoryLogDto;
import com.blt.other.entrepot.service.InventoryLogService;
import com.blt.other.entrepot.service.InventoryService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

@RestController
@RequestMapping("inventory/detail")
public class InventoryDetailController {

    @Autowired
    private InventoryService inventoryService;

    @Autowired
    private InventoryLogService inventoryLogService;

    @PostMapping("/getInventoryDetail")
    public Map<String,Object> getInventoryDetail(HttpServletResponse response,HttpServletRequest request){
        AxiosUtil.setCors(response,request);
        Map<String,Object> result = new HashMap<>();

        String inventoryNo = request.getParameter("inventoryNo");
        InventoryDomain inventoryDomain = inventoryService.getByInventoryNo(inventoryNo);

        result.put("success",true);
        result.put("inventory",inventoryDomain);
        result.put("msg","");
        return result;
    }

    @PostMapping("/acquireSave")
    public Map<String,Object> acquireSave(HttpServletResponse response,HttpServletRequest request) {
        AxiosUtil.setCors(response, request);
        Map<String,Object> result = new HashMap<>();

        Enumeration<String> parameterNames = request.getParameterNames();
        if (parameterNames.hasMoreElements()){
            String s = parameterNames.nextElement();
            InventoryLogDomain inventoryLogDomain = (InventoryLogDomain)MyMapperUtil.getObject(s, InventoryLogDomain.class);
            if (null != inventoryLogDomain){
                if (inventoryLogDomain.getNumLater() < 0 || inventoryLogDomain.getNumBefore() == 0){
                    result.put("success",false);
                    result.put("msg","库存不足");
                    return result;
                }
                if ((inventoryLogDomain.getNumLater()-inventoryLogDomain.getNumBefore()) >= 0) {
                    result.put("success",false);
                    result.put("msg","请输入有效数量");
                    return result;
                }

                return doSave(result,inventoryLogDomain);
            }
        }
        result.put("success",false);
        result.put("msg","发生错误");
        return result;
    }

    @PostMapping("giveBacckSave")
    public Map<String,Object> giveBacckSave(HttpServletResponse response,HttpServletRequest request) {
        AxiosUtil.setCors(response, request);
        Map<String,Object> result = new HashMap<>();

        Enumeration<String> parameterNames = request.getParameterNames();
        if (parameterNames.hasMoreElements()){
            String s = parameterNames.nextElement();
            InventoryLogDomain inventoryLogDomain = (InventoryLogDomain)MyMapperUtil.getObject(s, InventoryLogDomain.class);
            if (null != inventoryLogDomain){
                if ((inventoryLogDomain.getNumLater()-inventoryLogDomain.getNumBefore()) <= 0) {
                    result.put("success",false);
                    result.put("msg","请输入有效数量");
                    return result;
                }
                return doSave(result,inventoryLogDomain);
            }
        }
        result.put("success",false);
        result.put("msg","发生错误");
        return result;
    }


    /**
     * 执行更改库存信息、生成日志记录
     * @param result
     * @param inventoryLogDomain
     * @return
     */
    private Map<String,Object> doSave(Map<String,Object> result,InventoryLogDomain inventoryLogDomain){
        // 更改库存信息
        InventoryDomain inventoryDomain = new InventoryDomain();
        inventoryDomain.setInventoryNo(inventoryLogDomain.getInventoryNo());
        inventoryService.update(inventoryDomain,inventoryLogDomain.getNumLater());
        // 生成日志记录
        InventoryLogDto inventoryLogDto = inventoryLogService.save(inventoryLogDomain);
        result.put("success",true);
        result.put("inventoryLogDto",inventoryLogDto);
        result.put("msg","保存成功");

        return result;
    }

}
