package com.blt.other.entrepot.controller;

import com.blt.other.commons.utils.AxiosUtil;
import com.blt.other.entrepot.service.InventoryService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Map;

@RestController
@RequestMapping("inventory/list")
public class InventoryController {

    @Autowired
    private InventoryService inventoryService;

    @GetMapping("/getAllInventories")
    public Map<String,Object> getAllInventories(HttpServletResponse response,HttpServletRequest request){
        AxiosUtil.setCors(response,request);
        String pageNumStr = request.getParameter("pageNum");
        Integer pageNum = Integer.parseInt(pageNumStr);
        String pageSizeStr = request.getParameter("pageSize");
        Integer pageSize = Integer.parseInt(pageSizeStr);

        Map<String, Object> allInventories = inventoryService.getAllInventories(pageNum, pageSize);
        allInventories.put("success",true);

        return allInventories;
    }

}
