package com.blt.other.cost.job;


import com.blt.other.auth.dao.UserDao;
import com.blt.other.cost.dao.CostDao;
import com.blt.other.cost.dao.CostLogDao;
import com.bailuntec.cost.api.dto.CostDto;
import com.blt.other.cost.service.CostService;
import com.blt.other.database.model.CostDomain;
import com.blt.other.database.model.CostLogDomain;
import com.blt.other.database.model.UserDomain;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.quartz.QuartzJobBean;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

public class CostStatusSyncJob extends QuartzJobBean {

    private static Logger logger = LoggerFactory.getLogger(CostCompanySyncJob.class);

    @Autowired
    private CostService costService;

    @Autowired
    private CostLogDao costLogDao;

    @Autowired
    private CostDao costDao;

    @Autowired
    private UserDao userDao;

    @Override
    protected void executeInternal(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        logger.info("系统自动作废驳回费用单");
        List<CostDto> costDtoList = costService.getCostByRejectStatus();
        for(CostDto costDto : costDtoList) {
            CostDomain costDomain = new CostDomain();
            costDomain.setCostNo(costDto.getCostNo());
            costDomain.setCostStatus(5);
            int result = costDao.update(costDomain);
            if(result > 0) {
                CostLogDomain costLog = new CostLogDomain();
                costLog.setCostNo(costDto.getCostNo());
                costLog.setUpdateTime(new Date());
                UserDomain user = userDao.selectByuserid(2493);
                costLog.setUpdateUsercode(user.getUsercode());
                costLog.setUpdateUserid(2493);
                costLog.setUpdateUsername(user.getUsername());
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                costLog.setUpdateNote(sdf.format(costLog.getUpdateTime())+"  过期财务驳回单系统自动作废  更新人："+user.getUsername());
                costLogDao.insert(costLog);
            }
        }
    }
}
