package com.blt.other.cost.controller;

import com.blt.other.commons.utils.AxiosUtil;
import com.blt.other.commons.utils.PathUtil;
import com.blt.other.cost.service.CostPlanService;
import com.blt.other.cost.service.UserCostFinansysService;
import com.blt.other.cost.utils.CostFileUtil;
import com.blt.other.cost.utils.CostPlanUtils;
import com.blt.other.database.model.CostPlanDomain;
import com.blt.other.database.model.UserCostFinansysDomain;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.Map;

@RestController
@RequestMapping("/cost/plan/new/lend1")
public class CostPlanNewLend1Controller {

   @Autowired
   private CostPlanService costPlanService;

    @Autowired
    private UserCostFinansysService userCostFinansysService;

    @PostMapping("/saveFile")
    public Map<String,Object> save(HttpServletResponse response, HttpServletRequest request,@RequestParam("fileSelect") MultipartFile file){
        AxiosUtil.setCors(response,request);
        Map<String,Object> result = new HashMap<>();

        String costPlanNo = request.getParameter("costPlanNo");
        CostPlanDomain costPlan = CostPlanUtils.createCostPlan(request, costPlanNo);

        // 文件上传的路径
        String filePath = PathUtil.getBasePath()+PathUtil.getPath("cost/"+costPlan.getCostPlanNo()+"/");
        // 调用工具类执行保存，并返回 path
        String path = CostFileUtil.upload(file, filePath);

        costPlan.setFilePath(path);

        // 保存财务信息
        if (1 == costPlan.getCostForm() || (3 == costPlan.getCostForm() && 1 == costPlan.getIsLend())){
            Integer finansyRecord = doSaveFinansyRecord(costPlan);
        }

        Integer integer = costPlanService.save(costPlan);

        if (null != integer && integer >= 1){
            result.put("msg","借支计划已创建");
            result.put("costPlanNo",costPlan.getCostPlanNo());
            result.put("plan",costPlan);
            return result;
        }
        result.put("msg","借支计划创建失败");

        return result;
    }

    @PostMapping("/saveNoFile")
    public Map<String,Object> save(HttpServletResponse response, HttpServletRequest request){
        AxiosUtil.setCors(response,request);
        Map<String,Object> result = new HashMap<>();

        String costPlanNo = request.getParameter("costPlanNo");
        CostPlanDomain costPlan = CostPlanUtils.createCostPlan(request, costPlanNo);

        // 保存财务信息
        if (1 == costPlan.getCostForm() || (3 == costPlan.getCostForm() && 1 == costPlan.getIsLend())){
            Integer finansyRecord = doSaveFinansyRecord(costPlan);
        }

        Integer integer = costPlanService.save(costPlan);

        if (null != integer && integer >= 1){
            result.put("msg","借支计划已创建");
            result.put("plan",costPlan);
            result.put("costPlanNo",costPlan.getCostPlanNo());
            return result;
        }
        result.put("msg","借支计划创建失败");

        return result;
    }

    /**
     * 保存填写的财务信息
     * @return
     */
    private Integer doSaveFinansyRecord(CostPlanDomain planDomain){
        UserCostFinansysDomain finansyRecordByCostDomain = userCostFinansysService.createFinansyRecordByCostPlanDomain(planDomain);
        Integer integer = userCostFinansysService.saveFinansysRecord(finansyRecordByCostDomain);
        return integer;
    }
}
