package com.blt.other.commons.utils;

import com.blt.other.auth.vo.GetByBLUserAcct;
import com.blt.other.auth.vo.UserGetByBLUserAcct;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

import java.io.IOException;

/**
 * 通过前端 cookie 中的 BLUserAcct，从 OA 系统获取用户信息
 */
public class UserFromOAUtil {

    public static UserGetByBLUserAcct getUserMsg(String BLUserAcct,String logingUserApi){

        RestTemplate restTemplate = new RestTemplate();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        MultiValueMap<String, String> params= new LinkedMultiValueMap<String, String>();
        params.add("BLUserAcct",BLUserAcct);
        HttpEntity<MultiValueMap<String, String>> httpEntity = new HttpEntity<MultiValueMap<String, String>>(params, headers);
        ResponseEntity<String> response = restTemplate.postForEntity(logingUserApi, httpEntity, String.class);


        ObjectMapper mapper = new ObjectMapper();
        String strBody = null;
        if (response != null && response.getStatusCodeValue() == 200) {
            strBody = response.getBody();
        }
        strBody=strBody.toLowerCase();
        GetByBLUserAcct getByBLUserAcct = null;
        try {
            getByBLUserAcct = mapper.readValue(strBody, GetByBLUserAcct.class);
        } catch (IOException e) {
            e.printStackTrace();
        }
        return getByBLUserAcct.getData();
    }
}
